package de.ugoe.cs.eventbench.markov;

import java.util.LinkedList;
import java.util.List;

public class IncompleteMemory<T> implements IMemory<T> {

	private int length;
	
	private List<T> history;
	
	public IncompleteMemory(int length) {
		this.length = length;
		history = new LinkedList<T>();
	}
	
	@Override
	public void add(T state) {
		if( history.size()==length ) {
			history.remove(0);
		}
		history.add(state);
	}

	@Override
	public List<T> getLast(int num) {
		return new LinkedList<T>(history); // defensive copy
	}

	public int getLength() {
		return history.size();
	}
}
