/**
 * 
 */
package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * @author sherbold
 *
 */
public class CMDmodelSize implements Command {

	/* (non-Javadoc)
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		Object dataObject = GlobalDataContainer.getInstance().getData(modelname);
		if( dataObject==null ) {
			Console.printerrln("No model with name " + modelname + "found");
			return;
		}
		if( !(dataObject instanceof IStochasticProcess) ) {
			Console.printerrln("Object " + modelname + " not of type IStochasticProcess!");
			return;
		}
		
		IStochasticProcess process = (IStochasticProcess) dataObject;
		Console.println("#symbols: " + process.getNumSymbols() + " ; #FOMstates " + process.getNumFOMStates());
	}

	/* (non-Javadoc)
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		// TODO Auto-generated method stub

	}

}
