package de.ugoe.cs.eventbench.swing;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JButton;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.Vector;
import java.util.List;

import javax.swing.AbstractListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import java.awt.Color;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.data.IReplayable;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.windows.WindowsEvent;

import javax.swing.JLabel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;


public class DlgSequenceDetails {

	private JFrame frmEvents;
	private JFrame frmParent;

	/**
	 * Launch the application, the index of the sequence to work on is stored in sequenceIndex
	 */
	public void ShowDialog(JFrame parent, final List<Event<?>> events) {
		frmParent = parent;
		
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					DlgSequenceDetails window = new DlgSequenceDetails(frmParent, events);
					window.frmEvents.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public DlgSequenceDetails(JFrame parent, final List<Event<?>> events) {
		frmParent = parent;
		initialize(events);
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize(final List<Event<?>> events) {
		
		
		final javax.swing.DefaultListModel modelListEvents = new javax.swing.DefaultListModel();
		final javax.swing.DefaultListModel modelListTargets = new javax.swing.DefaultListModel();
		final JList listSequences = new JList(modelListEvents);
		final JList listTargets = new JList(modelListTargets);
		// ***
		
		
		// JFrame: frmEvents
		frmEvents = new JFrame();
		frmEvents.setResizable(false);
		frmEvents.setTitle("Sequence details");
		frmEvents.setBounds(100, 100, 666, 492);
		frmEvents.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		frmEvents.getContentPane().setLayout(null);

		frmEvents.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent arg0) {
				frmParent.setVisible(true);
				frmEvents.dispose();
			}
		});
		
		updateLists(events, modelListEvents, modelListTargets);
		
		JPanel panel = new JPanel();
		panel.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel.setBounds(10, 402, 639, 52);
		frmEvents.getContentPane().add(panel);
		panel.setLayout(null);
		final JButton btnInsertBefore = new JButton("Insert before");
		btnInsertBefore.setBounds(10, 11, 124, 31);
		panel.add(btnInsertBefore);
		// ***
		
		
		// JButton: btnInsertBefore ***
		btnInsertBefore.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent arg0) {
				if(!btnInsertBefore.isEnabled()) return;
				
				int selectedIndex = listSequences.getSelectedIndex();
				DlgInsert dlgInsert = new DlgInsert(events, selectedIndex, true);
				dlgInsert.ShowDialog(events, selectedIndex, true);
				
				updateLists(events, modelListEvents, modelListTargets);
				listSequences.setSelectedIndex(selectedIndex);
			}
		});
		
		btnInsertBefore.setEnabled(false);
		final JButton btnInsertAfter = new JButton("Insert after");
		btnInsertAfter.setBounds(144, 11, 124, 31);
		panel.add(btnInsertAfter);
		// ***
		
		
		// JButton: btnInsertAfter
		btnInsertAfter.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent arg0) {
				if(!btnInsertAfter.isEnabled()) return;
				
				int selectedIndex = listSequences.getSelectedIndex();
				DlgInsert dlgInsert = new DlgInsert(events, selectedIndex, false);
				dlgInsert.ShowDialog(events, selectedIndex, false);
				
				updateLists(events, modelListEvents, modelListTargets);
				listSequences.setSelectedIndex(selectedIndex+1);
			}
		});
		
		btnInsertAfter.setEnabled(false);
		
		final JButton btnClose = new JButton("Back to sequences");
		btnClose.setBounds(505, 11, 124, 31);
		panel.add(btnClose);
		
		JPanel panel_1 = new JPanel();
		panel_1.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel_1.setBounds(10, 11, 639, 380);
		frmEvents.getContentPane().add(panel_1);
		panel_1.setLayout(null);
		
		JScrollPane scrollPane_1 = new JScrollPane();
		scrollPane_1.setBounds(10, 29, 309, 339);
		panel_1.add(scrollPane_1);
		scrollPane_1.setViewportView(listSequences);
		// ***
		
		
		// JList: listSequences ***
		listSequences.setBorder(new SoftBevelBorder(BevelBorder.LOWERED, null, null, null, null));
		listSequences.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		
		// JScrollPane: scrollPane
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(329, 29, 298, 339);
		panel_1.add(scrollPane);
		
		listTargets.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent arg0) {
				if(listTargets.getSelectedIndex() > -1) {
					listSequences.setSelectedIndex(listTargets.getSelectedIndex());
					btnInsertAfter.setEnabled(true);
					
					if(listTargets.getSelectedIndex() == 0) {
						btnInsertBefore.setEnabled(false);						
					}
					else {
						btnInsertBefore.setEnabled(true);
					}
				}
			}
		});
		scrollPane.setViewportView(listTargets);
		// ***
		
		
		// JList for targets ***		
		listTargets.setBorder(new SoftBevelBorder(BevelBorder.LOWERED, null, null, null, null));
		listTargets.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		JLabel lblEvents = new JLabel("Events:");
		lblEvents.setBounds(10, 11, 46, 14);
		panel_1.add(lblEvents);
		
		JLabel lblTargets = new JLabel("Targets:");
		lblTargets.setBounds(329, 11, 58, 14);
		panel_1.add(lblTargets);
		
		listSequences.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent arg0) {
				if(listSequences.getSelectedIndex() > -1) {
					listTargets.setSelectedIndex(listSequences.getSelectedIndex());
					
					if(listSequences.getSelectedIndex() == 0) {
						btnInsertBefore.setEnabled(false);
						btnInsertAfter.setEnabled(true);
					}
					else {
						btnInsertBefore.setEnabled(true);
						btnInsertAfter.setEnabled(true);
					}
				}
			}
		});
		// ***
		
		
		// JButton: btnClose ***
		btnClose.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent arg0) {
				frmParent.setVisible(true);
				frmEvents.dispose();
			}
		});
		// ***
	}

	private void updateLists(final List<Event<?>> events,
			final javax.swing.DefaultListModel modelListEvents,
			final javax.swing.DefaultListModel modelListTargets) {
		
		modelListEvents.clear();
		modelListTargets.clear();
		for(int i=0; i<events.size(); i++) {
			modelListEvents.addElement(events.get(i).getType());
			modelListTargets.addElement(events.get(i).getTarget());
		}
	}
}
