// replay.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "LogParser.h"
#include "SAXContentHandlerImpl.h"
#include <iostream>

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc<3) 
	{
		std::wcout << "Usage: " << argv[0] << "<replayfile> <applicationundertest> [<resultfile>]" << std::endl;
		return 0;
	}

	// initialize COM library for the current thread
	CoInitialize(NULL); 
	MSXML2::ISAXXMLReader* pXMLReader = NULL;

	// create an instance of the XML reader
	HRESULT hr = CoCreateInstance(
		__uuidof(MSXML2::SAXXMLReader), 
		NULL, 
		CLSCTX_ALL, 
		__uuidof(MSXML2::ISAXXMLReader), 
		(void **)&pXMLReader);

	if( !FAILED(hr) ) {
		TestResults results(argv[1]);
		std::wcout << L"replaying sessions in " << argv[1] << std::endl;
		LogParser * parser = new LogParser(argv[2], 5000, &results, true);
		pXMLReader->putContentHandler(parser);
		hr = pXMLReader->parseURL(argv[1]);
		pXMLReader->Release();
		std::wcout << L"================================================" << std::endl;
		std::wcout << L"replay completed" << std::endl;
		if( argc>=4 ) {
			results.write(argv[3]);
			std::wcout << L"results written to " << argv[3] << std::endl;
		}
	}

	CoUninitialize();

	std::wcout << L"press enter to exit ...";
	getchar();

	return 0;
}

