package de.ugoe.cs.eventbench.swing;

import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Console;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.JScrollPane;

public class DlgSequences {

	private JFrame frmSequences;
	private List<List<Event<?>>> containedSequences;

	/**
	 * Launch the application.
	 */
	public static void showDialog() {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					DlgSequences window = new DlgSequences();
					window.frmSequences.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public DlgSequences() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmSequences = new JFrame();
		final javax.swing.DefaultListModel modelListSequences = new javax.swing.DefaultListModel();
		final JButton btnSequence = new JButton("Show details");
		final JButton btnClose = new JButton("Close");
		JPanel panel = new JPanel();
		
		
		// JFrame: frmSequence ***
		frmSequences.setTitle("Sequences");
		frmSequences.setResizable(false);
		frmSequences.setBounds(100, 100, 270, 332);
		frmSequences.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		frmSequences.getContentPane().setLayout(null);


		//!!!
		// is checked by calling "showSequences" -> Needed?
		//!!!
		try {
			containedSequences = (List<List<Event<?>>>) GlobalDataContainer.getInstance().getData("sequences");
		}
		catch(ClassCastException e) {
			Console.println("Not able to cast Data in GlobalDataContainer to List of Sequences");
		}
		
		try {
			for(int i=0; i<containedSequences.size(); i++) {
				modelListSequences.addElement("Sequence " + (i+1) + ": " + containedSequences.get(i).size() + " Events");
			}
		}
		catch(NullPointerException e) {
			Console.println("No sequences found.");
		}
		
		
		panel.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel.setBounds(10, 11, 244, 218);
		frmSequences.getContentPane().add(panel);
		panel.setLayout(null);
		// ***
		
		
		// JScrollPane: scrollPane
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(10, 11, 224, 196);
		panel.add(scrollPane);
		final JList listSequences = new JList(modelListSequences);
		scrollPane.setViewportView(listSequences);
		// ***

		
		
		// JList: listSequnces
		listSequences.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent arg0) {
				if(listSequences.getSelectedIndex() >= 0) btnSequence.setEnabled(true);
				else btnSequence.setEnabled(false);
			}
		});
		
		JPanel panel_1 = new JPanel();
		panel_1.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel_1.setBounds(10, 240, 244, 53);
		frmSequences.getContentPane().add(panel_1);
		panel_1.setLayout(null);
		// ***
		
		
		// JButton: btnSequence ***
		btnSequence.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent arg0) {
				if(btnSequence.isEnabled()) {
					DlgSequenceDetails dlgSequences = new DlgSequenceDetails(frmSequences, containedSequences.get(listSequences.getSelectedIndex()));
					dlgSequences.showDialog(frmSequences, containedSequences.get(listSequences.getSelectedIndex()));
					frmSequences.setVisible(false);
				}
			}
		});
		btnSequence.setBounds(124, 11, 110, 32);
		panel_1.add(btnSequence);
		btnSequence.setEnabled(false);
		// ***
		
		
		//JButton: btnClose ***		
		btnClose.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent arg0) {
				frmSequences.dispose();
			}
		});
		btnClose.setBounds(10, 11, 110, 32);
		panel_1.add(btnClose);
		// ***
	}
}
