package de.ugoe.cs.eventbench.swing;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.util.List;

import de.ugoe.cs.eventbench.assertions.AssertEvent;
import de.ugoe.cs.eventbench.assertions.FileEqualsReplay;
import de.ugoe.cs.eventbench.assertions.TextEqualsReplay;
import de.ugoe.cs.eventbench.data.Event;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.JFileChooser;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JScrollPane;
import javax.swing.JList;

public class DlgInsert extends JDialog {
	
	/**
	 * Id for object serialization.
	 */
	private static final long serialVersionUID = 1L;

	private final JPanel contentPanel = new JPanel();
	private JTextField textFieldExpectedValue;
	private JTextField textFieldActualFile;
	private JTextField textFieldExpectedFile;

	/**
	 * Launch the application.
	 */
	public static void showDialog(List<Event<?>> sequences, int selectedIndex, final boolean insertBefore) {
		try {
			DlgInsert dialog = new DlgInsert(sequences, selectedIndex, insertBefore);
			dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
			dialog.setVisible(true);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Create the dialog.
	 */
	public DlgInsert(final List<Event<?>> sequences, final int selectedIndex, final boolean insertBefore) {
		
		final javax.swing.DefaultListModel modelListTargets = new javax.swing.DefaultListModel();
		
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		setTitle("Insert testcase");
		
		
		setModal(true);
		setBounds(100, 100, 522, 482);
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);
		contentPanel.setLayout(null);
		final JComboBox comboBoxTestcase = new JComboBox();
		final JPanel panelTextEquals = new JPanel();
		final JPanel panelFileEquals = new JPanel();
		
		
		// JComboBox: comboBoxTestcase
		comboBoxTestcase.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				if ("comboBoxChanged".equals(arg0.getActionCommand())) {
					
					//TextEquals
					if(comboBoxTestcase.getSelectedIndex() == 0) {
						panelTextEquals.setVisible(true);
						panelFileEquals.setVisible(false);
					}
					//FileEquals
					else if(comboBoxTestcase.getSelectedIndex() == 1) {
						panelTextEquals.setVisible(false);
						panelFileEquals.setVisible(true);
					}
				}
			}
		});
		comboBoxTestcase.setModel(new DefaultComboBoxModel(new String[] {"TextEquals", "OutputFileEquals"}));
		comboBoxTestcase.setSelectedIndex(0);
		comboBoxTestcase.setBounds(128, 11, 178, 20);
		contentPanel.add(comboBoxTestcase);
		// ***
		
		
		// JLabel	
		JLabel label = new JLabel("Testcase:");
		label.setBounds(10, 14, 86, 14);
		contentPanel.add(label);
		
		JLabel label_1 = new JLabel("Expected value:");
		label_1.setBounds(10, 11, 83, 14);
		
		JLabel label_2 = new JLabel("Target:");
		label_2.setBounds(10, 38, 86, 14);
		// ***
		
		
		// JTextField: textFieldExpectedValue
		textFieldExpectedValue = new JTextField();
		textFieldExpectedValue.setColumns(10);
		textFieldExpectedValue.setBounds(116, 8, 368, 20);
		// ***
		
		
		// JPanel: panel
		panelTextEquals.setLayout(null);
		panelTextEquals.setBounds(10, 39, 494, 210);
		contentPanel.add(panelTextEquals);
		panelTextEquals.add(label_1);
		panelTextEquals.add(label_2);
		panelTextEquals.add(textFieldExpectedValue);
		
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(116, 36, 368, 163);
		panelTextEquals.add(scrollPane);
		
		final JList listTargets = new JList(modelListTargets);
		scrollPane.setViewportView(listTargets);
		
		for(int i=0; i<sequences.size(); i++) {
			if(sequences.get(i).getTarget() != " ") modelListTargets.addElement(sequences.get(i).getTarget());
		}
		listTargets.setSelectedIndex(0);
		
		
		panelFileEquals.setBounds(10, 260, 494, 140);
		contentPanel.add(panelFileEquals);
		panelFileEquals.setLayout(null);
		panelFileEquals.setVisible(false);
		
		JLabel lblNewLabel = new JLabel("Actual file:");
		lblNewLabel.setBounds(10, 11, 89, 14);
		panelFileEquals.add(lblNewLabel);
		
		textFieldActualFile = new JTextField();
		textFieldActualFile.setBounds(10, 36, 474, 20);
		panelFileEquals.add(textFieldActualFile);
		textFieldActualFile.setColumns(10);
		
		JButton btnNewButton = new JButton("Search file");
		btnNewButton.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent arg0) {
				final JFileChooser fc = new JFileChooser();
				if(fc.showOpenDialog(contentPanel) == 0) { textFieldExpectedFile.setText(fc.getSelectedFile().getAbsolutePath());	}
			}
		});
		btnNewButton.setBounds(99, 80, 89, 23);
		panelFileEquals.add(btnNewButton);
		
		JLabel lblNewLabel_1 = new JLabel("Expected file:");
		lblNewLabel_1.setBounds(10, 84, 89, 14);
		panelFileEquals.add(lblNewLabel_1);
		
		textFieldExpectedFile = new JTextField();
		textFieldExpectedFile.setColumns(10);
		textFieldExpectedFile.setBounds(10, 109, 474, 20);
		panelFileEquals.add(textFieldExpectedFile);
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT));
			getContentPane().add(buttonPane, BorderLayout.SOUTH);
			{
				// JButton: okButton
				JButton okButton = new JButton("Insert");
				okButton.addMouseListener(new MouseAdapter() {
					public void mouseClicked(MouseEvent arg0) {
						
						//FileEquals
						if(panelFileEquals.isVisible()) {
							if(textFieldActualFile.getText().length() == 0) JOptionPane.showMessageDialog(null, "Please declare an actual file.", "No actual file declared", JOptionPane.OK_OPTION);
							else if(! new File(textFieldExpectedFile.getText()).exists()) {
								if(textFieldExpectedFile.getText().length() == 0) JOptionPane.showMessageDialog(null, "Please choose an expected file.", "No expected file chosen", JOptionPane.OK_OPTION);
								else JOptionPane.showMessageDialog(null, "The expected file \"" + textFieldActualFile.getText() + "\" does not exist.", "Expected file does not exist", JOptionPane.OK_OPTION);
								return;
							}
							else {
								FileEqualsReplay file = new FileEqualsReplay();
								file.setActualFile(textFieldActualFile.getText());
								file.setExpectedFile(textFieldExpectedFile.getText());
								
								AssertEvent<FileEqualsReplay> e = new AssertEvent<FileEqualsReplay>("FileEquals");
								e.addReplayEvent(file);
								e.setTarget(" ");
								if(insertBefore) sequences.add(selectedIndex, e);
								else sequences.add(selectedIndex+1, e);
							}
						}
						//TextEquals
						else {
							if(textFieldExpectedValue.getText().length() == 0) {
								JOptionPane.showMessageDialog(null, "\"Expected value\" is missing.", "Expected value", JOptionPane.OK_OPTION);
								return;
							}
							else if(listTargets.getSelectedIndex() == -1) {
								JOptionPane.showMessageDialog(null, "Please select a target.", "No target selected", JOptionPane.OK_OPTION);
								return;
							}
							else {
								TextEqualsReplay text = new TextEqualsReplay();
								text.setExpectedValue(textFieldExpectedValue.getText());
								text.setTarget(modelListTargets.get(listTargets.getSelectedIndex()).toString());
								
								AssertEvent<TextEqualsReplay> e = new AssertEvent<TextEqualsReplay>("TextEquals");
								e.addReplayEvent(text);
								e.setTarget(" ");
								if(insertBefore) sequences.add(selectedIndex, e);
								else sequences.add(selectedIndex+1, e);
							}
						}
						
						dispose();
					}
				});
				okButton.setActionCommand("OK");
				buttonPane.add(okButton);
				getRootPane().setDefaultButton(okButton);
				// ***
			}
			
			{
				// JButton: cancelButton
				JButton cancelButton = new JButton("Cancel");
				cancelButton.addMouseListener(new MouseAdapter() {
					
					public void mouseClicked(MouseEvent arg0) {	dispose(); }
				});
				cancelButton.setActionCommand("Cancel");
				buttonPane.add(cancelButton);
				// ***
			}
		}
		// ***
	}
}
