package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;
import java.util.Random;

import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.DeterministicFiniteAutomaton;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDtrainDFA implements Command {

	@Override
	public void help() {
		Console.println("Usage: trainDFA <modelName>");
	}

	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		List<List<Event<?>>> sequences = null;
		Object dataObject = GlobalDataContainer.getInstance().getData("sequences");
			
		try {
			sequences = (List<List<Event<?>>>) dataObject;
			if( sequences.size()>0 ) {
				if( sequences.get(0).get(0) instanceof Event ) {
					DeterministicFiniteAutomaton model =  new DeterministicFiniteAutomaton(new Random());
					model.train(sequences);
					if( GlobalDataContainer.getInstance().addData(modelname, model) ) {
						Console.traceln("Old data \"" + modelname + "\" overwritten");
					}
				} else {
					Console.traceln("Illegal use of \"sequences\" parameter in the GlobalDataContainer.");
					Console.traceln("The parameter should always be of type List<List<? extends Event<?>>!");
				}
			}
		}
		catch(ClassCastException e) {
			Console.println("Sequences need to be loaded first using parseXML");
		}
	}

}
