/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.BasicVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.GradientVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class GraphZoomScrollPaneDemo {
    DirectedSparseGraph<String, Number> graph = new DirectedSparseGraph();
    VisualizationViewer<String, Number> vv;

    public GraphZoomScrollPaneDemo() {
        String[] v = this.createVertices(10);
        this.createEdges(v);
        ImageIcon sandstoneIcon = null;
        String imageLocation = "/images/Sandstone.jpg";
        try {
            sandstoneIcon = new ImageIcon(this.getClass().getResource(imageLocation));
        }
        catch (Exception ex) {
            System.err.println("Can't load \"" + imageLocation + "\"");
        }
        final ImageIcon icon = sandstoneIcon;
        this.vv = new VisualizationViewer((Layout)new KKLayout(this.graph));
        if (icon != null) {
            this.vv.addPreRenderPaintable(new VisualizationServer.Paintable(){

                public void paint(Graphics g) {
                    Dimension d = GraphZoomScrollPaneDemo.this.vv.getSize();
                    g.drawImage(icon.getImage(), 0, 0, d.width, d.height, (ImageObserver)GraphZoomScrollPaneDemo.this.vv);
                }

                public boolean useTransform() {
                    return false;
                }
            });
        }
        this.vv.addPostRenderPaintable(new VisualizationServer.Paintable(){
            int x;
            int y;
            Font font;
            FontMetrics metrics;
            int swidth;
            int sheight;
            String str = "GraphZoomScrollPane Demo";

            public void paint(Graphics g) {
                Dimension d = GraphZoomScrollPaneDemo.this.vv.getSize();
                if (this.font == null) {
                    this.font = new Font(g.getFont().getName(), 1, 30);
                    this.metrics = g.getFontMetrics(this.font);
                    this.swidth = this.metrics.stringWidth(this.str);
                    this.sheight = this.metrics.getMaxAscent() + this.metrics.getMaxDescent();
                    this.x = (d.width - this.swidth) / 2;
                    this.y = (int)((double)d.height - (double)this.sheight * 1.5);
                }
                g.setFont(this.font);
                Color oldColor = g.getColor();
                g.setColor(Color.lightGray);
                g.drawString(this.str, this.x, this.y);
                g.setColor(oldColor);
            }

            public boolean useTransform() {
                return false;
            }
        });
        this.vv.addGraphMouseListener(new TestGraphMouseListener());
        this.vv.getRenderer().setVertexRenderer((Renderer.Vertex)new GradientVertexRenderer(Color.white, Color.red, Color.white, Color.blue, this.vv.getPickedVertexState(), false));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(new ConstantTransformer<Color>(Color.lightGray));
        this.vv.getRenderContext().setArrowFillPaintTransformer(new ConstantTransformer<Color>(Color.lightGray));
        this.vv.getRenderContext().setArrowDrawPaintTransformer(new ConstantTransformer<Color>(Color.lightGray));
        this.vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        this.vv.setEdgeToolTipTransformer((Transformer)new Transformer<Number, String>(){

            @Override
            public String transform(Number edge) {
                return "E" + GraphZoomScrollPaneDemo.this.graph.getEndpoints((Object)edge).toString();
            }
        });
        this.vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        this.vv.getRenderer().getVertexLabelRenderer().setPositioner((Renderer.VertexLabel.Positioner)new BasicVertexLabelRenderer.InsidePositioner());
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.AUTO);
        this.vv.setForeground(Color.lightGray);
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        frame.setDefaultCloseOperation(3);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        this.vv.setToolTipText("<html><center>Type 'p' for Pick mode<p>Type 't' for Transform mode");
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(GraphZoomScrollPaneDemo.this.vv, 1.1f, GraphZoomScrollPaneDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(GraphZoomScrollPaneDemo.this.vv, 0.9090909f, GraphZoomScrollPaneDemo.this.vv.getCenter());
            }
        });
        JButton reset = new JButton("reset");
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphZoomScrollPaneDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
                GraphZoomScrollPaneDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW).setToIdentity();
            }
        });
        JPanel controls = new JPanel();
        controls.add(plus);
        controls.add(minus);
        controls.add(reset);
        content.add((Component)controls, "South");
        frame.pack();
        frame.setVisible(true);
    }

    private String[] createVertices(int count) {
        String[] v = new String[count];
        for (int i = 0; i < count; ++i) {
            v[i] = "V" + i;
            this.graph.addVertex((Object)v[i]);
        }
        return v;
    }

    void createEdges(String[] v) {
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[0], (Object)v[1], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[0], (Object)v[3], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[0], (Object)v[4], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[4], (Object)v[5], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[3], (Object)v[5], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[1], (Object)v[2], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[1], (Object)v[4], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[8], (Object)v[2], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[3], (Object)v[8], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[6], (Object)v[7], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[7], (Object)v[5], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[0], (Object)v[9], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[9], (Object)v[8], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[7], (Object)v[6], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[6], (Object)v[5], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[4], (Object)v[2], EdgeType.DIRECTED);
        this.graph.addEdge((Object)new Double(Math.random()), (Object)v[5], (Object)v[4], EdgeType.DIRECTED);
    }

    public static void main(String[] args) {
        new GraphZoomScrollPaneDemo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestGraphMouseListener<V>
    implements GraphMouseListener<V> {
        TestGraphMouseListener() {
        }

        public void graphClicked(V v, MouseEvent me) {
            System.err.println("Vertex " + v + " was clicked at (" + me.getX() + "," + me.getY() + ")");
        }

        public void graphPressed(V v, MouseEvent me) {
            System.err.println("Vertex " + v + " was pressed at (" + me.getX() + "," + me.getY() + ")");
        }

        public void graphReleased(V v, MouseEvent me) {
            System.err.println("Vertex " + v + " was released at (" + me.getX() + "," + me.getY() + ")");
        }
    }
}

