package de.ugoe.cs.eventbench.data;

import java.security.InvalidParameterException;



public class Event<T> {
	
	public static final Event<Object> STARTEVENT = new Event<Object>("START");
	public static final Event<Object> ENDEVENT = new Event<Object>("END");
	
	/**
	 * <p>
	 * Type of the event.
	 * </p>
	 */
	private String type;
	
	/**
	 * </p>
	 * Target of the event.
	 */
	private String target = null;
	
	/**
	 * <p>
	 * Short description of the event target.
	 * </p>
	 */
	private String targetShort = null;


	private String idInfo = "";
	
	public Event(String type) {
		if( type==null ) {
			throw new InvalidParameterException("Event type must not be null");
		}
		this.type = type;
	}

	@Override
	public boolean equals(Object other) {
		if( this==other ) {
			return true;
		}
		if (other instanceof Event<?>) {
			Event<?> otherEvent = (Event<?>) other;
			if( target!=null ) {
				return type.equals(otherEvent.type)
					&& target.equals(otherEvent.target);
			} else {
				return type.equals(otherEvent.type)
					&& target==otherEvent.target;
			}
		} else {
			return false;
		}
	}
	
	@Override
	public String toString() {
		return getStandardId();
	}

	public String getIdInfo() {
		return idInfo;
	}

	public String getShortId() {
		String shortId = null;
		if (targetShort!=null) {
			shortId = targetShort+"."+getType();
			if (idInfo!="") {
				shortId += "."+idInfo;
			}
		}
		return shortId;
	}

	public String getStandardId() {
		String id = "";
		if( target!=null ) {
			id += target + ".";
		}
		id += getType();
		if ( idInfo!="" ) {
			id += "." + idInfo;
		}
		return id;
	}

	public String getTarget() {
		return target;
	}
	
	public String getTargetShort() {
		return targetShort;
	}

	public String getType() {
		return type;
	}

	@Override
	public int hashCode() {
		int multiplier = 17;
		int hash = 42;
		hash = multiplier * hash + type.hashCode();
		if( target!=null ) {
			hash = multiplier * hash + target.hashCode();
		}

		return hash;
	}

	public void setIdInfo(String info) {
		idInfo = info;
	}
	
	/**
	 * <p>
	 * Sets the target of the event. Once set, the target cannot be changed.
	 * </p> 
	 * @param target target of the event
	 * @return true, if target was changed, false otherwise
	 */
	public boolean setTarget(String target) {
		if( this.target!=null ) {
			return false;
		}
		this.target = target;
		return true;
	}
	
	/**
	 * <p>
	 * Sets the short description of the event target. Once set, the target cannot be changed.
	 * </p> 
	 * @param targetShort short target description
	 * @return true, if target was changed, false otherwise
	 */
	public boolean setTargetShort(String targetShort) {
		if( this.targetShort!=null ) {
			return false;
		}
		this.targetShort = targetShort;
		return true;
	}
}
