package de.ugoe.cs.util;

final public class ArrayTools {
	
	/**
	 * <p>
	 * Finds the first occurence of an object inside an array.
	 * </p>
	 * <p>
	 * In case {@code other==null}, the first occurence of a {@code null} value in the array is returned.
	 * </p>
	 *  
	 * @param array the array
	 * @param other the object
	 * @return index of the object if found, -1 otherwise
	 */
	public static int findIndex(Object[] array, Object other) {
		int retVal = -1;
		for( int i=0 ; i<array.length && retVal==-1 ; i++ ) {
			if( other!=null ) {
				if( array[i]!=null && array[i].equals(other) ) {
					retVal = i;
				}
			} else {
				if( array[i]==null ) {
					retVal = i;
				}
			}
		}
		return retVal;
	}
}
