package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.eventbench.ReplayGenerator;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.data.ReplayableEvent;
import de.ugoe.cs.eventbench.markov.MarkovModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDgenerateRandomReplay implements Command {

	@Override
	public void help() {
		Console.println("Usage: generateRandomReplay <modelName> <filename> {<numSessions>}");
	}

	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		String filename;
		int numSessions = 1;
		try {
			modelname = (String) parameters.get(0);
			filename = (String) parameters.get(1);
			if( parameters.size()<3 ) {
				numSessions = Integer.parseInt((String) parameters.get(2));
			}
		}
		catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		MarkovModel model = null; 
		Object dataObject = GlobalDataContainer.getInstance().getData(modelname);
		if( dataObject==null ) {
			Console.println("Model " + modelname + " not found in storage.");
		}
		else if( !(dataObject instanceof MarkovModel) ) {
			Console.println("Object " + modelname + " not of type MarkovModel!");
		} else {
			model = (MarkovModel) dataObject;
			List<List<ReplayableEvent<?>>> sequences = new LinkedList<List<ReplayableEvent<?>>>();
			try {
				for( int i=0 ; i<numSessions ; i++ ) {
					sequences.add((List<ReplayableEvent<?>>) model.randomSequence());
				}
			} catch (ClassCastException e) {
				Console.println("Modeled events don't support replay.");
			}
			ReplayGenerator generator = new ReplayGenerator();
			generator.createLogfileMultipleSessions(sequences, filename);
		}
	}

}
