// replay.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "LogParser.h"
#include "SAXContentHandlerImpl.h"
#include <iostream>

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc<4) 
	{
		std::wcout << "Usage: " << argv[0] << "<replayfile> <applicationundertest> [<resultfile>] [<useDefaultDelay>] [<waitAfterFinish>]" << std::endl;
		return 0;
	}
	TCHAR * replayfile = argv[1];
	TCHAR * appUnderTest = argv[2];
	TCHAR * resultfile = NULL;
	bool useDefaultDelay = true;
	int wait = 1;
	if( argc>=4 ) {
		TCHAR * resultfile = argv[3];
	}
	if( argc>=5 ) {
		useDefaultDelay = (bool) _tstoi(argv[4]);
	} 
	if( argc>=6 ) {
		wait = _tstoi(argv[5]);
	}

	// initialize COM library for the current thread
	CoInitialize(NULL); 
	MSXML2::ISAXXMLReader* pXMLReader = NULL;

	// create an instance of the XML reader
	HRESULT hr = CoCreateInstance(
		__uuidof(MSXML2::SAXXMLReader), 
		NULL, 
		CLSCTX_ALL, 
		__uuidof(MSXML2::ISAXXMLReader), 
		(void **)&pXMLReader);

	if( !FAILED(hr) ) {
		TestResults results(replayfile);
		std::wcout << L"replaying sessions in " << argv[1] << std::endl;
		LogParser * parser = new LogParser(appUnderTest, 5000, &results, useDefaultDelay);
		pXMLReader->putContentHandler(parser);
		hr = pXMLReader->parseURL(replayfile);
		pXMLReader->Release();
		std::wcout << L"================================================" << std::endl;
		std::wcout << L"replay completed" << std::endl;
		if( resultfile!=NULL ) {
			results.write(resultfile);
			std::wcout << L"results written to " << resultfile << std::endl;
		}
	}

	CoUninitialize();
	
	if( wait!=0 ) {
		std::wcout << L"press enter to exit ...";
		getchar();
	}

	return 0;
}

