package de.ugoe.cs.eventbench.assertions;

import de.ugoe.cs.eventbench.data.IReplayable;
import de.ugoe.cs.util.StringTools;

public class TextEqualsReplay implements IReplayable {

	private String expectedValue = null;
	private String target = null;
	/**
	 * Id for object serialization.
	 */
	private static final long serialVersionUID = 1L;

	public void setExpectedValue(String s) {
		expectedValue = s;
	}

	public void setTarget(String s) {
		target = s;
	}

	public String getReplay() {

		expectedValue = StringTools.xmlEntityReplacement(expectedValue);
		
		StringBuilder currentMsgStr = new StringBuilder(400);
		currentMsgStr.append(" <textEquals expectedValue=\"" + expectedValue + "\">");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("<target>");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append(target);
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("</target>");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("</textEquals>");
		currentMsgStr.append(StringTools.ENDLINE);
		return currentMsgStr.toString();
	}


	public String getTarget() {
		return target;
	}

}
