package de.ugoe.cs.util.console;

/**
 * <p>
 * Observer for Console.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface ConsoleObserver {

	/**
	 * <p>
	 * If a new message is send to the console, all observers are updated using
	 * this method.
	 * </p>
	 * 
	 * @param newMessage
	 *            message that was send to the console.
	 */
	public void updateText(String newMessage);

	/**
	 * <p>
	 * Send messages to the error stream of all observers.
	 * </p>
	 * 
	 * @param errMessage
	 *            error message
	 */
	public void errStream(String errMessage);

	/**
	 * <p>
	 * Send messages to the trace stream of all observers.
	 * </p>
	 * 
	 * @param traceMesssage
	 *            error message
	 */
	public void trace(String traceMessage);

	/**
	 * <p>
	 * Prints the stack trace of an exception.
	 * </p>
	 * 
	 * @param e
	 *            exception whose stack trace is to be printed
	 */
	public void printStacktrace(Exception e);

	/**
	 * <p>
	 * Receives the command strings of all executed commands.
	 * </p>
	 * 
	 * @param command
	 *            string of the command.
	 */
	public void commandExecuted(String command);

}
