package de.ugoe.cs.eventbench.swt;

import java.util.Collection;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.TextConsole;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;

public class MainWindow {

	protected Shell shell;
	private Text textCommand;
	private Text textConsoleOutput;
	private List list;

	/**
	 * Launch the application.
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO this main method needs to be removed/remodeled when merging with other project
		try {
			CommandExecuter.getInstance().addCommandPackage(
					"de.ugoe.cs.eventbench.commands");
			CommandExecuter.getInstance().addCommandPackage(
					"de.ugoe.cs.eventbench.windows.commands");
			CommandExecuter.getInstance().addCommandPackage(
					"de.ugoe.cs.eventbench.web.commands");
			new TextConsole();
			
			MainWindow window = new MainWindow();
			window.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Open the window.
	 */
	public void open() {
		Display display = Display.getDefault();
		createContents();
		new SWTConsole(textConsoleOutput);
		shell.open();
		shell.layout();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
	}

	/**
	 * Create contents of the window.
	 */
	protected void createContents() {
		shell = new Shell();
		shell.setSize(500, 300);
		shell.setText("SWT Application");
		shell.setLayout(new GridLayout(1, false));
		
		Menu menu = new Menu(shell, SWT.BAR);
		shell.setMenuBar(menu);
		
		MenuItem mntmFile = new MenuItem(menu, SWT.CASCADE);
		mntmFile.setText("File");
		
		Menu menu_1 = new Menu(mntmFile);
		mntmFile.setMenu(menu_1);
		
		MenuItem mntmShowHistory = new MenuItem(menu_1, SWT.NONE);
		mntmShowHistory.setText("Show History");
		
		MenuItem mntmExecBatchFile = new MenuItem(menu_1, SWT.NONE);
		mntmExecBatchFile.setText("Exec. Batch File");
		
		new MenuItem(menu_1, SWT.SEPARATOR);
		
		MenuItem mntmLoad = new MenuItem(menu_1, SWT.NONE);
		mntmLoad.setText("Load...");
		
		MenuItem mntmSave = new MenuItem(menu_1, SWT.NONE);
		mntmSave.setText("Save...");
		
		new MenuItem(menu_1, SWT.SEPARATOR);
		
		MenuItem mntmExit = new MenuItem(menu_1, SWT.NONE);
		mntmExit.setText("Exit");
		
		MenuItem mntmHelp = new MenuItem(menu, SWT.CASCADE);
		mntmHelp.setText("Help");
		
		Menu menu_2 = new Menu(mntmHelp);
		mntmHelp.setMenu(menu_2);
		
		MenuItem mntmAbout = new MenuItem(menu_2, SWT.NONE);
		mntmAbout.setText("About");
		
		TabFolder tabFolder = new TabFolder(shell, SWT.NONE);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		TabItem tbtmConsoleMode = new TabItem(tabFolder, SWT.NONE);
		tbtmConsoleMode.setText("Console");
		
		Composite composite = new Composite(tabFolder, SWT.NO_BACKGROUND);
		tbtmConsoleMode.setControl(composite);
		composite.setLayout(new GridLayout(3, false));
		
		Label lblCommand = new Label(composite, SWT.NONE);
		lblCommand.setText("Command:");
		
		textCommand = new Text(composite, SWT.BORDER);
		textCommand.addKeyListener(new KeyAdapter() {
			@Override
			public void keyReleased(KeyEvent e) {
				if( e.keyCode==SWT.CR ) {
					String command = textCommand.getText().trim();
					CommandExecuter.getInstance().exec(command);
				}
			}
		});
		GridData gd_textCommand = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_textCommand.widthHint = 304;
		textCommand.setLayoutData(gd_textCommand);
		
		Button btnEnter = new Button(composite, SWT.NONE);
		btnEnter.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				// Event handler for executing commands
				String command = textCommand.getText().trim();
				CommandExecuter.getInstance().exec(command);
			}
		});
		btnEnter.setText("Enter");
		
		textConsoleOutput = new Text(composite, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.CANCEL);
		GridData gd_textConsoleOutput = new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1);
		gd_textConsoleOutput.heightHint = 102;
		gd_textConsoleOutput.widthHint = 456;
		textConsoleOutput.setLayoutData(gd_textConsoleOutput);
		
		TabItem tbtmSequences = new TabItem(tabFolder, SWT.NONE);
		tbtmSequences.setText("Sequences");
		
		Composite composite_2 = new Composite(tabFolder, SWT.NO_BACKGROUND);
		tbtmSequences.setControl(composite_2);
		composite_2.setLayout(new GridLayout(5, false));
		
		list = new List(composite_2, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		list.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1));
		list.setItems(new String[] {});
		for( String sequencesName : GlobalDataContainer.getInstance().getAllSequencesNames() ) {
			list.add(sequencesName);
		}
		
		Button btnEdit = new Button(composite_2, SWT.NONE);
		btnEdit.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO edit sequences event handler
			}
		});
		btnEdit.setText("Edit");
		
		Button btnDelete = new Button(composite_2, SWT.NONE);
		btnDelete.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String[] selectedSequences = list.getSelection();
				for( String selected : selectedSequences) {
					GlobalDataContainer.getInstance().removeData(selected);
				}
			}
		});
		btnDelete.setText("Delete");
		
		Button btnReplay = new Button(composite_2, SWT.NONE);
		btnReplay.setText("Replay");
		
		Button btnTrainModel = new Button(composite_2, SWT.NONE);
		btnTrainModel.setText("Train Model");
		
		Button btnParse = new Button(composite_2, SWT.NONE);
		btnParse.setText("Parse");
		
		TabItem tbtmModels = new TabItem(tabFolder, SWT.NONE);
		tbtmModels.setText("Models");
		
		Composite composite_1 = new Composite(tabFolder, SWT.NO_BACKGROUND);
		tbtmModels.setControl(composite_1);
		composite_1.setLayout(new GridLayout(5, false));
		
		List list_1 = new List(composite_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		list_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1));
		
		Button btnShow = new Button(composite_1, SWT.NONE);
		btnShow.setText("Visualize");
		
		Button btnDelete_1 = new Button(composite_1, SWT.NONE);
		btnDelete_1.setText("Delete");
		
		Button btnGenSequences = new Button(composite_1, SWT.NONE);
		btnGenSequences.setText("Gen. Sequences");
		
		Button btnProperties = new Button(composite_1, SWT.NONE);
		btnProperties.setText("Properties");
		
		Button btnCreateDot = new Button(composite_1, SWT.NONE);
		btnCreateDot.setText("Create DOT");
		
		TabItem tbtmData = new TabItem(tabFolder, SWT.NONE);
		tbtmData.setText("Data");
		
		Composite composite_3 = new Composite(tabFolder, SWT.NO_BACKGROUND);
		tbtmData.setControl(composite_3);
		composite_3.setLayout(new GridLayout(3, false));
		
		List list_2 = new List(composite_3, SWT.BORDER | SWT.V_SCROLL);
		list_2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));
		
		Button btnLoad = new Button(composite_3, SWT.NONE);
		btnLoad.setText("Load");
		
		Button btnSave = new Button(composite_3, SWT.NONE);
		btnSave.setText("Save");
		
		Button btnDelete_2 = new Button(composite_3, SWT.NONE);
		btnDelete_2.setText("Delete");

	}
	public Text getTextConsoleOutput() {
		return textConsoleOutput;
	}
}
