package de.ugoe.cs.eventbench.swt;

import org.eclipse.swt.widgets.Text;

import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.ConsoleObserver;

public class SWTConsole implements ConsoleObserver {

	Text output;
	
	public SWTConsole(Text output) {
		Console.getInstance().registerObserver(this);
		this.output = output;
	}
	
	@Override
	public void updateText(String newMessage) {
		output.append(newMessage);
	}

	@Override
	public void errStream(String errMessage) {
		output.append(errMessage);

	}

	@Override
	public void trace(String traceMessage) {
		output.append(traceMessage);
	}

	@Override
	public void printStacktrace(Exception e) {
		// TODO print stacktrace
	}
	
	@Override
	public void commandNotification(String command) {
		output.append("> " + command);	
	}
}
