package de.ugoe.cs.eventbench.swt;

import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;

public class TrainModelDialog extends Dialog {

	protected Object result;
	protected Shell shlTrainUsageModel;
	private Text text_1;

	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public TrainModelDialog(Shell parent, int style) {
		super(parent, style);
		setText("SWT Dialog");
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public Object open() {
		createContents();
		shlTrainUsageModel.open();
		shlTrainUsageModel.layout();
		Display display = getParent().getDisplay();
		while (!shlTrainUsageModel.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shlTrainUsageModel = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.MIN | SWT.APPLICATION_MODAL);
		shlTrainUsageModel.setSize(219, 279);
		shlTrainUsageModel.setText("Train Usage Model");
		shlTrainUsageModel.setLayout(new GridLayout(2, false));
		
		Group grpGeneralInformation = new Group(shlTrainUsageModel, SWT.NONE);
		grpGeneralInformation.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 2, 1));
		grpGeneralInformation.setText("Name");
		grpGeneralInformation.setLayout(new GridLayout(1, false));
		
		text_1 = new Text(grpGeneralInformation, SWT.BORDER);
		text_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		Group grpType = new Group(shlTrainUsageModel, SWT.NONE);
		grpType.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 2, 1));
		grpType.setText("Type");
		grpType.setLayout(new GridLayout(1, false));
		
		Button btnFirstorderMarkovModel = new Button(grpType, SWT.RADIO);
		btnFirstorderMarkovModel.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		btnFirstorderMarkovModel.setText("First-Order Markov Model");
		
		Button btnHighorderMarkovModel = new Button(grpType, SWT.RADIO);
		btnHighorderMarkovModel.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		btnHighorderMarkovModel.setText("High-Order Markov Model");
		
		Button btnPredictionByPartial = new Button(grpType, SWT.RADIO);
		btnPredictionByPartial.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		btnPredictionByPartial.setText("Prediction by Partial Match");
		
		Button btnDeterministicFiniteAutomaton = new Button(grpType, SWT.RADIO);
		btnDeterministicFiniteAutomaton.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		btnDeterministicFiniteAutomaton.setText("Deterministic Finite Automaton");
		
		Group grpModelProperties = new Group(shlTrainUsageModel, SWT.NONE);
		grpModelProperties.setLayout(new GridLayout(4, false));
		grpModelProperties.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true, 2, 1));
		grpModelProperties.setText("Order");
		
		Label lblMin = new Label(grpModelProperties, SWT.NONE);
		lblMin.setText("Min.");
		
		Spinner spinner_1 = new Spinner(grpModelProperties, SWT.BORDER);
		
		Label lblMax = new Label(grpModelProperties, SWT.NONE);
		lblMax.setText("Max.");
		
		Spinner spinner = new Spinner(grpModelProperties, SWT.BORDER);
		new Label(grpModelProperties, SWT.NONE);
		new Label(grpModelProperties, SWT.NONE);
		new Label(grpModelProperties, SWT.NONE);
		new Label(grpModelProperties, SWT.NONE);
		
		Button btnTrain = new Button(shlTrainUsageModel, SWT.NONE);
		btnTrain.setText("Train!");
		
		Button btnAbort = new Button(shlTrainUsageModel, SWT.NONE);
		btnAbort.setText("Abort");

	}
}
