package de.ugoe.cs.eventbench.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class ModelsTabComposite extends Composite {

	List modelList;
	
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public ModelsTabComposite(Composite parent, int style) {
		super(parent, style);
		createContents();
	}
	
	private void createContents() {
		setLayout(new GridLayout(5, false));
		
		modelList = new List(this, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		modelList.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1));
		
		Button btnShow = new Button(this, SWT.NONE);
		btnShow.setText("Visualize");
		
		Button btnDelete_1 = new Button(this, SWT.NONE);
		btnDelete_1.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if( SWTHelpers.deleteSelectedFromStorage(modelList) ) {
					updateModelList();
				} else {
					SWTHelpers.noSelectionError(getShell());
				}
			}
		});
		btnDelete_1.setText("Delete");
		
		Button btnGenSequences = new Button(this, SWT.NONE);
		btnGenSequences.setText("Gen. Sequences");
		
		Button btnProperties = new Button(this, SWT.NONE);
		btnProperties.setText("Properties");
		
		Button btnCreateDot = new Button(this, SWT.NONE);
		btnCreateDot.setText("Create DOT");
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	
	public void updateModelList() {
		modelList.removeAll();
		for( String sequencesName : GlobalDataContainer.getInstance().getAllModelNames() ) {
			modelList.add(sequencesName);
		}
	}

}
