/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.model;

import edu.umd.cs.guitar.util.GUITARLog;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class XMLHandler {
    public Object readObjFromFile(InputStream is, Class<?> cls) {
        Object retObj = null;
        try {
            String packageName = cls.getPackage().getName();
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Unmarshaller u = jc.createUnmarshaller();
            retObj = u.unmarshal(is);
        }
        catch (JAXBException e) {
            GUITARLog.log.error((Object)e);
        }
        return retObj;
    }

    public Object readObjFromFile(String sFileName, Class<?> cls) {
        Object retObj = null;
        try {
            InputStream in = this.getClass().getResourceAsStream(sFileName);
            retObj = this.readObjFromFile(in, cls);
        }
        catch (Exception e) {
            System.out.println("File " + sFileName + " not found");
        }
        return retObj;
    }

    public void writeObjToFile(Object object, OutputStream os) {
        String packageName = object.getClass().getPackage().getName();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(object, os);
            os.close();
        }
        catch (JAXBException e) {
            GUITARLog.log.error((Object)e);
        }
        catch (IOException e) {
            GUITARLog.log.error((Object)e);
        }
    }

    public void writeObjToFile(Object object, String sFileName) {
        try {
            this.writeObjToFile(object, new FileOutputStream(sFileName));
        }
        catch (FileNotFoundException e) {
            GUITARLog.log.error((Object)e);
        }
    }
}

