package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command that prints a randomly generated sessions of events to the console.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDprintRandomSession implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: printRandomSession <modelName>");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		IStochasticProcess model = null;
		Object dataObject = GlobalDataContainer.getInstance()
				.getData(modelname);
		if (dataObject == null) {
			Console.println("Model " + modelname + " not found in storage.");
		} else if (!(dataObject instanceof IStochasticProcess)) {
			Console.println("Object " + modelname + " not of type MarkovModel!");
		} else {
			model = (IStochasticProcess) dataObject;
			for (Event<?> event : model.randomSequence()) {
				Console.println(event.toString());
			}
		}
	}

}
