package de.ugoe.cs.eventbench.swt;

import org.eclipse.swt.widgets.Text;

import de.ugoe.cs.util.StringTools;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.listener.ICommandListener;
import de.ugoe.cs.util.console.listener.IErrorListener;
import de.ugoe.cs.util.console.listener.IOutputListener;
import de.ugoe.cs.util.console.listener.ITraceListener;

public class SWTConsole implements IOutputListener, IErrorListener, ITraceListener, ICommandListener {

	Text output;
	
	public SWTConsole(Text output) {
		Console.getInstance().registerOutputListener(this);
		Console.getInstance().registerErrorListener(this);
		Console.getInstance().registerTraceListener(this);
		Console.getInstance().registerCommandListener(this);
		this.output = output;
	}
	
	@Override
	public void updateText(String newMessage) {
		output.append(newMessage);
	}

	@Override
	public void errStream(String errMessage) {
		output.append(errMessage);

	}

	@Override
	public void trace(String traceMessage) {
		output.append(traceMessage);
	}
	
	@Override
	public void commandNotification(String command) {
		output.append("> " + command + StringTools.ENDLINE);	
	}
}
