package de.ugoe.cs.util.console.listener;

import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Received all exceptions passed to the {@link Console} for logging.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface IExceptionListener {

	/**
	 * <p>
	 * Logs an exception passed to the {@link Console}.
	 * </p>
	 * 
	 * @param e
	 *            Exception that is logged
	 */
	public void printStacktrace(Exception e);
}
