package de.ugoe.cs.eventbench.commands;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to load a previously serialized object and store it in the
 * {@link GlobalDataContainer}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDloadObject implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		String objectName;
		try {
			filename = (String) parameters.get(0);
			objectName = (String) parameters.get(1);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		Object data = null;
		FileInputStream fis = null;
		ObjectInputStream in = null;
		try {
			fis = new FileInputStream(filename);
			in = new ObjectInputStream(fis);
			data = in.readObject();
			in.close();
		} catch (IOException ex) {
			Console.printStacktrace(ex);
		} catch (ClassNotFoundException ex) {
			Console.printStacktrace(ex);
		}
		if (GlobalDataContainer.getInstance().addData(objectName, data)) {
			Console.traceln("Old data \"" + objectName + "\" overwritten");
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: loadObject <filename> <objectName>");
	}

}
