package de.ugoe.cs.eventbench.commands;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command that loads a previously serialized {@link GlobalDataContainer}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDload implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		try {
			filename = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		FileInputStream fis = null;
		ObjectInputStream in = null;
		try {
			fis = new FileInputStream(filename);
			in = new ObjectInputStream(fis);
			in.readObject();
			in.close();
		} catch (IOException ex) {
			Console.printStacktrace(ex);
		} catch (ClassNotFoundException ex) {
			Console.printStacktrace(ex);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: loadObject <filename>");
	}

}
