package de.ugoe.cs.eventbench.commands;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command that saves an object contained in the {@link GlobalDataContainer}
 * through serialization.
 * </p>
 * 
 * @author Steffen Herbold
 * @version
 */
public class CMDsaveObject implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		String objectName;
		try {
			filename = (String) parameters.get(0);
			objectName = (String) parameters.get(1);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		Object dataObject = GlobalDataContainer.getInstance().getData(
				objectName);
		if (dataObject == null) {
			Console.println("Object " + objectName + " not found in storage.");
		}

		FileOutputStream fos = null;
		ObjectOutputStream out = null;
		try {
			fos = new FileOutputStream(filename);
			out = new ObjectOutputStream(fos);
			out.writeObject(dataObject);
			out.close();
		} catch (IOException ex) {
			Console.printStacktrace(ex);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: saveObject <filename> <objectName>");
	}

}
