package de.ugoe.cs.eventbench.web.data;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.eventbench.data.IReplayable;

/**
 * <p>
 * Contains all information related to a web request, i.e., the path, the POST
 * variables and the GET variables.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class WebRequest implements IReplayable {

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * <p>
	 * POST variables of the web request.
	 * </p>
	 */
	List<String> postVars;

	/**
	 * <p>
	 * GET variables of the web request.
	 * </p>
	 */
	List<String> getVars;

	/**
	 * <p>
	 * URI of the web request.
	 * </p>
	 */
	String targetUri;

	/**
	 * <p>
	 * Constructor. Creates a new WebRequest.
	 * </p>
	 * 
	 * @param uri
	 *            URI of the request
	 * @param postVars
	 *            POST variables of the request
	 * @param getVars
	 *            GET variables of the request
	 */
	public WebRequest(String uri, List<String> postVars, List<String> getVars) {
		targetUri = uri;
		this.postVars = new ArrayList<String>(postVars); // defensive copy
		this.getVars = new ArrayList<String>(getVars);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.eventbench.data.IReplayable#getReplay()
	 */
	@Override
	public String getReplay() {
		// TODO implement method
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.eventbench.data.IReplayable#getTarget()
	 */
	@Override
	public String getTarget() {
		// TODO implement method
		return null;
	}

	/**
	 * <p>
	 * Two {@link WebRequest}s are equal, if their {@link #targetUri},
	 * {@link #postVars}, and {@link #getVars} are equal.
	 * </p>
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (other instanceof WebRequest) {
			return targetUri.equals(((WebRequest) other).targetUri)
					&& postVars.equals(((WebRequest) other).postVars)
					&& getVars.equals(((WebRequest) other).getVars);
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		int multiplier = 17;
		int hash = 42;

		hash = multiplier * hash + targetUri.hashCode();
		hash = multiplier * hash + postVars.hashCode();
		hash = multiplier * hash + getVars.hashCode();

		return hash;
	}

}
