package de.ugoe.cs.eventbench.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map.Entry;
import java.util.SortedMap;
import java.util.TreeMap;

import de.ugoe.cs.eventbench.SequenceInstanceOf;
import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to print basic statistical information about stored sequences, e.g.,
 * how many there are of which lenght.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDsequenceStatistics implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String sequencesName = "sequences";
		if (parameters.size() == 1) {
			sequencesName = (String) parameters.get(0);
		}

		Collection<List<Event<?>>> sequences = null;
		Object dataObject = GlobalDataContainer.getInstance().getData(
				sequencesName);
		if (dataObject == null) {
			Console.println("Object " + sequencesName
					+ " not found in storage.");
			return;
		}
		if (!SequenceInstanceOf.isCollectionOfSequences(dataObject)) {
			Console.println("Object " + sequencesName
					+ "not of type Collection<List<Event<?>>>.");
			return;
		}

		sequences = (Collection<List<Event<?>>>) dataObject;
		Console.traceln("Number of Sequences: " + sequences.size());
		SortedMap<Integer, Integer> lengthMap = new TreeMap<Integer, Integer>();
		for (List<Event<?>> sequence : sequences) {
			Integer currentSize = sequence.size();
			if (lengthMap.containsKey(currentSize)) {
				lengthMap.put(currentSize, lengthMap.get(currentSize) + 1);
			} else {
				lengthMap.put(currentSize, 1);
			}
		}
		for (Entry<Integer, Integer> entry : lengthMap.entrySet()) {
			Console.traceln("Of length " + entry.getKey() + ": "
					+ entry.getValue());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: sequenceStatistics {<sequencesName>}");
	}

}
