package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.eventbench.swing.DlgSequences;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.data.Event;

public class CMDshowSequences implements Command {

	public void help() {
		Console.println("Usage: showSequences");
	}

	@SuppressWarnings("unchecked")
	public void run(List<Object> parameters) {

		if (parameters.size() > 0)
			throw new InvalidParameterException();

		Collection<List<Event<?>>> containedSequences = null;

		try {
			containedSequences = (Collection<List<Event<?>>>) GlobalDataContainer
					.getInstance().getData("sequences");
		} catch (ClassCastException e) {
			Console.println("Not able to cast Data in GlobalDataContainer to List of Sequences");
		}

		if (containedSequences == null) {
			Console.printerrln("No sequences found.");
		} else {

			DlgSequences.showDialog();

			synchronized (Console.getInstance()) {
				try {
					Console.getInstance().wait();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}
	}
}
