package de.ugoe.cs.eventbench.assertions;

import de.ugoe.cs.eventbench.data.IReplayable;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * This class defines the fileEquals assertion type. This type does have two
 * parameters, actualFile and expectedFile.
 * </p>
 * 
 * @author jeffrey.hall
 * @version 1.0
 * 
 */
public class FileEqualsReplay implements IReplayable {

	/**
	 * The file that should be equal to expectedFile.
	 */
	String actualFile = null;

	/**
	 * The file that is used as the reference.
	 */
	String expectedFile = null;

	/**
	 * Id for object serialization.
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 * @param actualFile
	 *            The file that should be equal to expectedFile.
	 */
	public void setActualFile(String actualFile) {
		this.actualFile = actualFile;
	}

	/**
	 * @param exptectedFile
	 *            The file that is used as the reference.
	 */
	public void setExpectedFile(String expectedFile) {
		this.expectedFile = expectedFile;
	}

	/**
	 * Returns the string that has to be written to the replay file.
	 */
	public String getReplay() {

		actualFile = StringTools.xmlEntityReplacement(actualFile);
		expectedFile = StringTools.xmlEntityReplacement(expectedFile);

		StringBuilder currentMsgStr = new StringBuilder(800);
		currentMsgStr.append("  <fileEquals ");
		currentMsgStr.append("actualFile=\"" + actualFile + "\" ");
		currentMsgStr.append("expectedFile=\"" + expectedFile + "\"/>");
		currentMsgStr.append(StringTools.ENDLINE);
		return currentMsgStr.toString();
	}

	/**
	 * No target used by fileEquals.
	 */
	public String getTarget() {
		return "targetNotUsed";
	}

}
