package de.ugoe.cs.eventbench.assertions;

import de.ugoe.cs.eventbench.data.IReplayable;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * This class defines the textEquals assertion type. This type does have two
 * parameters, expectedValue and target.
 * </p>
 * 
 * @author jeffrey.hall
 * @version 1.0
 * 
 */
public class TextEqualsReplay implements IReplayable {

	/**
	 * The reference value which is compared to the targets text.
	 */
	private String expectedValue = null;

	/**
	 * The window which text is compared to expectedValue.
	 */
	private String target = null;

	/**
	 * Id for object serialization.
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * @param expectedValue
	 *            The reference value which is compared to the targets text.
	 */
	public void setExpectedValue(String expectedValue) {
		this.expectedValue = expectedValue;
	}

	/**
	 * @param target
	 *            The window which text is compared to expectedValue.
	 */
	public void setTarget(String target) {
		this.target = target;
	}

	/**
	 * Returns the string that has to be written to the replay file.
	 */
	public String getReplay() {

		expectedValue = StringTools.xmlEntityReplacement(expectedValue);

		StringBuilder currentMsgStr = new StringBuilder(400);
		currentMsgStr.append(" <textEquals expectedValue=\"" + expectedValue
				+ "\">");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("<target>");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append(target);
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("</target>");
		currentMsgStr.append(StringTools.ENDLINE);
		currentMsgStr.append("</textEquals>");
		currentMsgStr.append(StringTools.ENDLINE);
		return currentMsgStr.toString();
	}

	/**
	 * Returns the target window.
	 */
	public String getTarget() {
		return target;
	}

}
