package de.ugoe.cs.eventbench.web.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.web.WeblogParser;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to load sessions from a web log.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDloadSessionsFromClickstream implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		if (parameters.size() < 1) {
			throw new InvalidParameterException();
		}
		String source = (String) parameters.get(0);
		String sequencesName = (String) parameters.get(1);
		int timeout = -1;
		int minLength = -1;
		int maxLength = -1;
		if (parameters.size() >= 4) {
			timeout = Integer.parseInt((String) parameters.get(2));
			minLength = Integer.parseInt((String) parameters.get(3));
			maxLength = Integer.parseInt((String) parameters.get(4));
		}

		WeblogParser parser = new WeblogParser();
		if (timeout != -1) {
			parser.setTimeout(timeout);
			parser.setMinLength(minLength);
			parser.setMaxLength(maxLength);
		}
		try {
			parser.parseFile(source);
		} catch (FileNotFoundException e) {
			Console.println(e.getMessage());
		} catch (IOException e) {
			Console.println(e.getMessage());
		} catch (ParseException e) {
			Console.println("Invalid format of date stamps.");
			Console.println(e.getMessage());
		}

		if (GlobalDataContainer.getInstance().addData(sequencesName,
				parser.getSequences())) {
			Console.traceln("Old data \"" + sequencesName + "\" overwritten");
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: loadSessionsFromClickstream <filename> <sequencesName> {<timeout> <minSessionLength> <maxSessionLength>}");
	}

}
