package de.ugoe.cs.eventbench.web.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.web.WeblogParser;
import de.ugoe.cs.eventbench.web.data.WebEvent;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to load sessions from a web log.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDloadSessionsFromClickstream implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		if (parameters.size() < 1) {
			throw new InvalidParameterException();
		}
		String source = (String) parameters.get(0);
		String sequencesName = (String) parameters.get(1);
		String serverUrl = null;
		int timeout = -1;
		int minLength = -1;
		int maxLength = -1;
		boolean generateFrequentUsers = false;
		int frequentUserThreshold = 20;
		if (parameters.size() >= 3) {
			serverUrl = (String) parameters.get(2);
		}
		if (parameters.size() >= 6) {
			timeout = Integer.parseInt((String) parameters.get(3));
			minLength = Integer.parseInt((String) parameters.get(4));
			maxLength = Integer.parseInt((String) parameters.get(5));
		}
		if (parameters.size() >= 8) {
			generateFrequentUsers = Boolean.parseBoolean((String) parameters
					.get(6));
			frequentUserThreshold = Integer
					.parseInt((String) parameters.get(7));
		}

		WeblogParser parser = new WeblogParser();
		if (serverUrl != null) {
			parser.setUrl(serverUrl);
		}
		if (timeout != -1) {
			parser.setTimeout(timeout);
			parser.setMinLength(minLength);
			parser.setMaxLength(maxLength);
		}
		if (generateFrequentUsers) {
			parser.setFrequentUserThreshold(frequentUserThreshold);
		}
		try {
			parser.parseFile(source);
		} catch (FileNotFoundException e) {
			Console.println(e.getMessage());
		} catch (IOException e) {
			Console.println(e.getMessage());
		} catch (ParseException e) {
			Console.println("Invalid format of date stamps.");
			Console.println(e.getMessage());
		}

		if (GlobalDataContainer.getInstance().addData(sequencesName,
				parser.getSequences())) {
			Console.traceln("Old data \"" + sequencesName + "\" overwritten");
		}
		if (generateFrequentUsers) {
			List<String> frequentUserIDs = parser.getFrequentUsers();
			List<Collection<List<WebEvent>>> frequentUserSessions = parser
					.getFrequentUserSequences();
			for (int i = 0; i < frequentUserIDs.size(); i++) {
				GlobalDataContainer.getInstance().addData(
						sequencesName + "_" + frequentUserIDs.get(i),
						frequentUserSessions.get(i));
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: loadSessionsFromClickstream <filename> <sequencesName> {<serverUrl>} {<timeout> <minSessionLength> <maxSessionLength>} {<generateFrequentUsers> <frequentUserThreshold>}");
	}

}
