package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.eventbench.SequenceInstanceOf;
import de.ugoe.cs.eventbench.coverage.CoverageCalculatorObserved;
import de.ugoe.cs.eventbench.coverage.CoverageCalculatorProcess;
import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to calculate the coverage of a test suite.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDcalcCoverage implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		String[] sequenceNames;
		int minLength;
		int maxLength;
		String observedName = "sequences";
		try {
			modelname = (String) parameters.get(0);
			sequenceNames = (String[]) parameters.get(1);
			minLength = Integer.parseInt((String) parameters.get(2));
			maxLength = Integer.parseInt((String) parameters.get(3));
			if (parameters.size() == 5) {
				observedName = (String) parameters.get(4);
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		IStochasticProcess process = null;
		Collection<List<? extends Event<?>>> observedSequences = null;
		Collection<List<? extends Event<?>>> sequences = null;
		Object dataObjectProcess = GlobalDataContainer.getInstance().getData(
				modelname);
		Object dataObjectObserved = GlobalDataContainer.getInstance().getData(
				observedName);
		if (dataObjectProcess == null) {
			Console.printerrln("Model " + modelname + " not found in storage.");
			return;
		}
		if (!(dataObjectProcess instanceof IStochasticProcess)) {
			Console.printerrln("Object " + modelname
					+ " not of type IStochasticProcess!");
			return;
		}
		if (dataObjectObserved == null) {
			Console.printerrln("Observed sequences not found in storage.");
			return;
		}
		if (!SequenceInstanceOf.isCollectionOfSequences(dataObjectObserved)) {
			Console.printerrln("Object " + observedName
					+ " of type Collection<List<Event<?>>>!");
			return;
		}
		process = (IStochasticProcess) dataObjectProcess;
		observedSequences = (Collection<List<? extends Event<?>>>) dataObjectObserved;

		Console.print("seqName");
		for (int length = minLength; length <= maxLength; length++) {
			Console.print(";numObs_" + length);
			Console.print(";numCov_" + length);
			Console.print(";numNew_" + length);
			Console.print(";numPos_" + length);
			Console.print(";all_" + length);
			Console.print(";pos_" + length);
			Console.print(";poswei_" + length);
			Console.print(";obs_" + length);
			Console.print(";obswei_" + length);
			Console.print(";new_" + length);
			Console.print(";newpos_" + length);
			Console.print(";newposwei_" + length);
		}
		Console.println("");
		for (String sequenceName : sequenceNames) {
			Object dataObjectSequences = GlobalDataContainer.getInstance()
					.getData(sequenceName);
			if (dataObjectSequences == null) {
				Console.println("Sequences " + sequenceName
						+ " not found in storage.");
				return;
			} else if (!SequenceInstanceOf
					.isCollectionOfSequences(dataObjectSequences)) {
				Console.printerrln("Object " + sequenceName
						+ "not of type Collection<List<Event<?>!");
				return;
			}
			sequences = (Collection<List<? extends Event<?>>>) dataObjectSequences;
			Console.print(sequenceName);
			for (int length = minLength; length <= maxLength; length++) {
				CoverageCalculatorProcess covCalcProc = new CoverageCalculatorProcess(
						process, sequences, length);
				CoverageCalculatorObserved covCalcObs = new CoverageCalculatorObserved(
						observedSequences, sequences, length);
				Console.print(";" + covCalcObs.getNumObserved());
				Console.print(";" + covCalcObs.getNumCovered());
				Console.print(";" + covCalcObs.getNumNew());
				Console.print(";" + covCalcProc.getNumPossible());
				Console.print(";" + covCalcProc.getCoverageAllNoWeight());
				Console.print(";" + covCalcProc.getCoveragePossibleNoWeight());
				Console.print(";" + covCalcProc.getCoveragePossibleWeight());
				Console.print(";" + covCalcObs.getCoverageObserved());
				Console.print(";"
						+ covCalcObs.getCoverageObservedWeigth(process));
				Console.print(";" + covCalcObs.getNewPercentage());
				Console.print(";" + covCalcObs.getCoveragePossibleNew(process));
				Console.print(";"
						+ covCalcObs.getCoveragePossibleNewWeight(process));
			}
			Console.println("");
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: calcCoverage <modelname> [sequenceNames] <minCovLength> <maxCovLength>");
	}

}
