package de.ugoe.cs.eventbench.commands;

import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;

import de.ugoe.cs.eventbench.SequenceInstanceOf;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.swt.SequencesDialog;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to show sequences.
 * </p>
 * 
 * @author Jeffrey Hall, Steffen Herbold
 */
public class CMDshowSequences implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: showSequences <sequencesName>");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String sequencesName = "sequences";
		if (parameters.size() == 1) {
			sequencesName = (String) parameters.get(0);
		}

		Object dataObject = GlobalDataContainer.getInstance().getData(
				sequencesName);
		if (dataObject == null) {
			Console.println("Object " + sequencesName
					+ " not found in storage.");
			return;
		}
		if (!SequenceInstanceOf.isCollectionOfSequences(dataObject)) {
			Console.println("Object " + sequencesName
					+ "not of type Collection<List<Event<?>>>.");
			return;
		}

		// TODO use SWT-GUI instead
		SequencesDialog sequencesDialog = new SequencesDialog(new Shell(), SWT.NONE);
		sequencesDialog.open(sequencesName);
			/*
			synchronized (Console.getInstance()) {
				try {
					Console.getInstance().wait();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}*/
	}
}
