package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.eventbench.CommandHelpers;
import de.ugoe.cs.eventbench.ReplayGenerator;
import de.ugoe.cs.eventbench.SequenceInstanceOf;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.data.ReplayableEvent;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to create a replay file from stored sessions.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDgenerateReplayfile implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: generateReplayfile <filename> {<sequences>}");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		if (parameters.size() < 1) {
			throw new InvalidParameterException();
		}
		String filename = (String) parameters.get(0);
		String sequencesName = "sequences";
		if (parameters.size() == 2) {
			sequencesName = (String) parameters.get(1);
		}

		Collection<List<ReplayableEvent<?>>> sequences = null;
		Object dataObject = GlobalDataContainer.getInstance().getData(
				sequencesName);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(sequencesName);
			return;
		}
		if (!SequenceInstanceOf.isCollectionOfSequences(dataObject)) {
			CommandHelpers.objectNotType(sequencesName,
					"Collection<List<Event<?>>>");
			return;
		}

		sequences = (Collection<List<ReplayableEvent<?>>>) dataObject;
		ReplayGenerator generator = new ReplayGenerator();
		generator.createLogfileMultipleSessions(sequences, filename);
	}

}
