package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.eventbench.CommandHelpers;
import de.ugoe.cs.eventbench.ReplayGenerator;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.data.ReplayableEvent;
import de.ugoe.cs.eventbench.models.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to create a replay file with randomly generated sessions.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDgenerateRandomReplay implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: generateRandomReplay <modelName> <filename> {<numSessions>}");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		String filename;
		int numSessions = 1;
		try {
			modelname = (String) parameters.get(0);
			filename = (String) parameters.get(1);
			if (parameters.size() < 3) {
				numSessions = Integer.parseInt((String) parameters.get(2));
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		IStochasticProcess model = null;
		Object dataObject = GlobalDataContainer.getInstance()
				.getData(modelname);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(modelname);
			return;
		}
		if (!(dataObject instanceof IStochasticProcess)) {
			CommandHelpers.objectNotType(modelname, "IStochasticProcess");
			return;
		}
		model = (IStochasticProcess) dataObject;
		Collection<List<ReplayableEvent<?>>> sequences = new LinkedList<List<ReplayableEvent<?>>>();
		try {
			for (int i = 0; i < numSessions; i++) {
				sequences
						.add((List<ReplayableEvent<?>>) model.randomSequence());
			}
		} catch (ClassCastException e) {
			Console.println("Modeled events don't support replay.");
		}
		ReplayGenerator generator = new ReplayGenerator();
		generator.createLogfileMultipleSessions(sequences, filename);
	}

}
