package de.ugoe.cs.eventbench.windows;

/**
 * <p>
 * Base class to define custom message handlers, for messages that shall be
 * handled differently during the parsing of usage logs. It provides dummy
 * implementations for all required methods, such that implementations can only
 * overwrite the parts they actually require and ignore the rest.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class MessageHandler {

	/**
	 * <p>
	 * Constructor. Protected to prohibit initialization of the base class
	 * itself.
	 * </p>
	 */
	protected MessageHandler() {
	}

	/**
	 * <p>
	 * Called in the startElement() method of the {@link LogParser} when a
	 * msg-node begins.
	 * </p>
	 */
	public void onStartElement() {
	}

	/**
	 * <p>
	 * Called by the {@link LogParser} to handle param-nodes.
	 * </p>
	 * 
	 * @param name
	 *            name (type) of the parameter
	 * @param value
	 *            value of the parameter
	 */
	public void onParameter(String name, String value) {
	}

	/**
	 * <p>
	 * Called in the endElement() method of {@link LogParser} when a msg-node
	 * ends.
	 * </p>
	 */
	public void onEndElement() {
	}
}
