package de.ugoe.cs.eventbench.web.data;

import java.util.List;

import de.ugoe.cs.eventbench.data.ReplayableEvent;

/**
 * <p>
 * This class defines web events (of PHP-based web applications).
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 * 
 */
public class WebEvent extends ReplayableEvent<WebRequest> {

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Timestamp of the event.
	 */
	private final long timestamp;

	/**
	 * <p>
	 * Helper method that generates the type of the event based on the of the
	 * URI, the POST variables, and the GET variables.
	 * </p>
	 * 
	 * @param path
	 *            path of the URI of the event
	 * @param postVars
	 *            POST variables send with the event
	 * @param getVars
	 *            GET variables send with the event
	 * @return type of the event
	 */
	private final static String makeType(String path, List<String> postVars,
			List<String> getVars) {
		String type = path;
		if (getVars != null && !getVars.isEmpty()) {
			type += "+GET" + getVars.toString().replace(" ", "");
		}
		if (postVars != null && !postVars.isEmpty()) {
			type += "+POST" + postVars.toString().replace(" ", "");
		}
		return type;
	}

	/**
	 * <p>
	 * Constructor. Creates a new WebEvent.
	 * </p>
	 * 
	 * @param url
	 *            URL of the server that received the event
	 * @param path
	 *            path of the URI
	 * @param timestamp
	 *            timestamp of when the event took place
	 * @param postVars
	 *            POST variables send with the event
	 * @param getVars
	 *            GET variables send with the event
	 */
	public WebEvent(String url, String path, long timestamp,
			List<String> postVars, List<String> getVars) {
		super(makeType(path, postVars, getVars));
		this.timestamp = timestamp;
		super.setTarget(path);
		addReplayEvent(new WebRequest(url, path, postVars, getVars));
	}

	/**
	 * <p>
	 * Returns the timestamp of the event.
	 * </p>
	 * 
	 * @return timestamp of th event
	 */
	public long getTimestamp() {
		return timestamp;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.eventbench.data.ReplayableEvent#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object other) {
		return super.equals(other);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.eventbench.data.ReplayableEvent#hashCode()
	 */
	@Override
	public int hashCode() {
		return super.hashCode();
	}

}
