/*
 * Decompiled with CFR 0.152.
 */
package junitx.tool;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class TestClassValidator {
    public static final String BANNER = "TestClassValidator, by Vladimir R. Bossicard";
    private ClassValidator validator = null;
    private ClassValidatorListener listener = null;
    static /* synthetic */ Class class$junit$framework$Test;

    public void setValidator(ClassValidator validator) {
        this.validator = validator;
    }

    public void setValidatorListener(ClassValidatorListener listener) {
        this.listener = listener;
    }

    private void init(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.validator = this.createValidator(args);
        this.listener = this.createValidatorListener(args);
        this.go(args);
    }

    private ClassValidator createValidator(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassValidator res = null;
        if (args[0].equals("-validator")) {
            res = (ClassValidator)Class.forName(args[1]).newInstance();
        } else if (args.length >= 3 && args[2].equals("-validator")) {
            if (res == null) {
                throw new IllegalStateException("Two validators are defined");
            }
            res = (ClassValidator)Class.forName(args[3]).newInstance();
        }
        return res;
    }

    private ClassValidatorListener createValidatorListener(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassValidatorListener res = null;
        if (args[0].equals("-listener")) {
            res = (ClassValidatorListener)Class.forName(args[1]).newInstance();
        } else if (args.length >= 3 && args[2].equals("-listener")) {
            if (res == null) {
                throw new IllegalStateException("Two listeners are defined");
            }
            res = (ClassValidatorListener)Class.forName(args[3]).newInstance();
        }
        return res;
    }

    private void go(String[] args) throws ClassNotFoundException {
        if (this.validator == null) {
            this.validator = new DefaultClassValidator();
        }
        if (this.listener == null) {
            this.listener = new ClassValidatorListener(){

                public void info(String message) {
                    System.out.println("INFO > " + message);
                }

                public void warning(String message) {
                    System.out.println("WARN > " + message);
                }

                public void error(String message) {
                    System.out.println("ERROR> " + message);
                }
            };
        }
        this.validator.setListener(this.listener);
        this.validator.validate(Class.forName(args[args.length - 1]));
    }

    private static void man() {
        System.out.println("usage: junitx.tool.TestClassValidator [-validator classname] [-listener classname] classname");
    }

    public static void main(String[] args) {
        try {
            System.out.println(BANNER);
            new TestClassValidator().init(args);
        }
        catch (Exception e) {
            TestClassValidator.man();
            System.out.println();
            e.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DefaultClassValidator
    implements ClassValidator {
        private ClassValidatorListener listener = null;

        public void setListener(ClassValidatorListener listener) {
            this.listener = listener;
        }

        public void validate(Class cls) {
            Class base = cls;
            while (base != null) {
                Method[] mtds = base.getDeclaredMethods();
                int ii = 0;
                while (ii < mtds.length) {
                    Method mtd = mtds[ii];
                    String name = mtd.getName();
                    if (name.equals("suite")) {
                        this.validateSuiteMethod(mtd);
                    } else if (name.equals("setUp")) {
                        this.validateSetUpMethod(mtd);
                    } else if (name.equals("tearDown")) {
                        this.validateTearDownMethod(mtd);
                    } else if (name.startsWith("test")) {
                        this.validateTestMethod(mtd);
                    } else {
                        this.validateOtherMethod(mtd);
                    }
                    ++ii;
                }
                base = base.getSuperclass();
            }
        }

        protected void validateSuiteMethod(Method method) {
            int modifier = method.getModifiers();
            if (!Modifier.isPublic(modifier)) {
                this.fireError(method.getDeclaringClass().getName() + ": method 'suite' must be public");
            }
            if (!Modifier.isStatic(modifier)) {
                this.fireError(method.getDeclaringClass().getName() + ": method 'suite' must be static");
            }
            if (method.getReturnType() != (class$junit$framework$Test == null ? (class$junit$framework$Test = TestClassValidator.class$("junit.framework.Test")) : class$junit$framework$Test)) {
                this.fireError(method.getDeclaringClass().getName() + ": method 'suite' must return Test");
            }
            if (method.getParameterTypes().length != 0) {
                this.fireError(method.getDeclaringClass().getName() + ": method 'suite' must have no argument");
            }
        }

        protected void validateSetUpMethod(Method method) {
            if (method.getParameterTypes().length != 0) {
                this.fireError(method.getDeclaringClass().getName() + ".setUp: method must have no argument");
            }
        }

        protected void validateTearDownMethod(Method method) {
            if (method.getParameterTypes().length != 0) {
                this.fireError(method.getDeclaringClass().getName() + ".tearDown: method must have no argument");
            }
        }

        protected void validateTestMethod(Method method) {
            if (method.getParameterTypes().length != 0) {
                this.fireError(method.getDeclaringClass().getName() + ": test method must have no argument");
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                this.fireError(method.getDeclaringClass().getName() + ": test method must be public");
            }
        }

        protected void validateOtherMethod(Method method) {
            String name = method.getName();
            if (name.toLowerCase().equals("setup")) {
                this.fireWarning(method.getDeclaringClass().getName() + ": method potentially misspelled <" + name + ">");
            } else if (name.toLowerCase().equals("teardown")) {
                this.fireWarning(method.getDeclaringClass().getName() + ": method potentially misspelled <" + name + ">");
            } else if (name.toLowerCase().equals("suite")) {
                this.fireWarning(method.getDeclaringClass().getName() + ": method potentially misspelled <" + name + ">");
            } else if (name.indexOf("test") > 0) {
                this.fireInfo(method.getDeclaringClass().getName() + ": method seems to be a test <" + name + ">");
            }
        }

        private void fireInfo(String message) {
            if (this.listener != null) {
                this.listener.info(message);
            }
        }

        private void fireWarning(String message) {
            if (this.listener != null) {
                this.listener.warning(message);
            }
        }

        private void fireError(String message) {
            if (this.listener != null) {
                this.listener.error(message);
            }
        }
    }

    public static interface ClassValidatorListener {
        public void info(String var1);

        public void warning(String var1);

        public void error(String var1);
    }

    public static interface ClassValidator {
        public void setListener(ClassValidatorListener var1);

        public void validate(Class var1);
    }
}

