/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.BalloonLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformerDecorator;
import edu.uci.ics.jung.visualization.transform.shape.HyperbolicShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ViewLensSupport;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class BalloonLayoutDemo
extends JApplet {
    Forest<String, Integer> graph;
    Factory<DirectedGraph<String, Integer>> graphFactory = new Factory<DirectedGraph<String, Integer>>(){

        public DirectedGraph<String, Integer> create() {
            return new DirectedSparseMultigraph();
        }
    };
    Factory<Tree<String, Integer>> treeFactory = new Factory<Tree<String, Integer>>(){

        public Tree<String, Integer> create() {
            return new DelegateTree(BalloonLayoutDemo.this.graphFactory);
        }
    };
    Factory<Integer> edgeFactory = new Factory<Integer>(){
        int i = 0;

        public Integer create() {
            return this.i++;
        }
    };
    Factory<String> vertexFactory = new Factory<String>(){
        int i = 0;

        public String create() {
            return "V" + this.i++;
        }
    };
    VisualizationViewer<String, Integer> vv;
    VisualizationServer.Paintable rings;
    String root;
    TreeLayout<String, Integer> layout;
    BalloonLayout<String, Integer> radialLayout;
    LensSupport hyperbolicViewSupport;

    public BalloonLayoutDemo() {
        this.graph = new DelegateForest();
        this.createTree();
        this.layout = new TreeLayout(this.graph);
        this.radialLayout = new BalloonLayout(this.graph);
        this.radialLayout.setSize(new Dimension(900, 900));
        this.vv = new VisualizationViewer(this.layout, new Dimension(600, 600));
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
        this.vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        this.vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        this.vv.getRenderContext().setArrowFillPaintTransformer((Transformer)new ConstantTransformer((Object)Color.lightGray));
        this.rings = new Rings(this.radialLayout);
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        this.hyperbolicViewSupport = new ViewLensSupport(this.vv, (LensTransformer)new HyperbolicShapeTransformer(this.vv, this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW)), (ModalGraphMouse)new ModalLensGraphMouse());
        graphMouse.addItemListener(this.hyperbolicViewSupport.getGraphMouse().getModeListener());
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        this.vv.scaleToLayout((ScalingControl)scaler);
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(BalloonLayoutDemo.this.vv, 1.1f, BalloonLayoutDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(BalloonLayoutDemo.this.vv, 0.9090909f, BalloonLayoutDemo.this.vv.getCenter());
            }
        });
        JToggleButton radial = new JToggleButton("Balloon");
        radial.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LayoutTransition lt = new LayoutTransition(BalloonLayoutDemo.this.vv, BalloonLayoutDemo.this.layout, BalloonLayoutDemo.this.radialLayout);
                    Animator animator = new Animator((IterativeContext)lt);
                    animator.start();
                    BalloonLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
                    BalloonLayoutDemo.this.vv.addPreRenderPaintable(BalloonLayoutDemo.this.rings);
                } else {
                    LayoutTransition lt = new LayoutTransition(BalloonLayoutDemo.this.vv, BalloonLayoutDemo.this.radialLayout, BalloonLayoutDemo.this.layout);
                    Animator animator = new Animator((IterativeContext)lt);
                    animator.start();
                    BalloonLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
                    BalloonLayoutDemo.this.vv.removePreRenderPaintable(BalloonLayoutDemo.this.rings);
                }
                BalloonLayoutDemo.this.vv.repaint();
            }
        });
        JRadioButton hyperView = new JRadioButton("Hyperbolic View");
        hyperView.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                BalloonLayoutDemo.this.hyperbolicViewSupport.activate(e.getStateChange() == 1);
            }
        });
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(radial);
        controls.add(scaleGrid);
        controls.add(modeBox);
        controls.add(hyperView);
        content.add((Component)controls, "South");
    }

    private void createTree() {
        this.graph.addVertex("A0");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "A0", "B0");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "A0", "B1");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "A0", "B2");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "B0", "C0");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "B0", "C1");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "B0", "C2");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "B0", "C3");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "C2", "H0");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "C2", "H1");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "B1", "D0");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "B1", "D1");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "B1", "D2");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "B2", "E0");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "B2", "E1");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "B2", "E2");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "D0", "F0");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "D0", "F1");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "D0", "F2");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "D1", "G0");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "D1", "G1");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "D1", "G2");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "D1", "G3");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "D1", "G4");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "D1", "G5");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "D1", "G6");
        this.graph.addEdge((Integer)this.edgeFactory.create(), "D1", "G7");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new BalloonLayoutDemo());
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Rings
    implements VisualizationServer.Paintable {
        BalloonLayout<String, Integer> layout;

        public Rings(BalloonLayout<String, Integer> layout) {
            this.layout = layout;
        }

        public void paint(Graphics g) {
            g.setColor(Color.gray);
            Graphics2D g2d = (Graphics2D)g;
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            for (String v : this.layout.getGraph().getVertices()) {
                Double radius = (Double)this.layout.getRadii().get(v);
                if (radius == null) continue;
                Point2D p = this.layout.transform((Object)v);
                ((RectangularShape)ellipse).setFrame(-radius.doubleValue(), -radius.doubleValue(), 2.0 * radius, 2.0 * radius);
                AffineTransform at = AffineTransform.getTranslateInstance(p.getX(), p.getY());
                Shape shape = at.createTransformedShape(ellipse);
                MutableTransformer viewTransformer = BalloonLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW);
                shape = viewTransformer instanceof MutableTransformerDecorator ? BalloonLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().transform(shape) : BalloonLayoutDemo.this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, shape);
                g2d.draw(shape);
            }
        }

        public boolean useTransform() {
            return true;
        }
    }
}

