package de.ugoe.cs.eventbench.data;



public class Event<T> {

	/**
	 * <p>
	 * Type of the event.
	 * </p>
	 */
	private String type;
	
	/**
	 * </p>
	 * Target of the event.
	 */
	private String target = null;
	
	/**
	 * <p>
	 * Short description of the event target.
	 * </p>
	 */
	private String targetShort = null;


	private String idInfo = null;
	
	public Event(String type) {
		this.type = type;
	}

	@Override
	public boolean equals(Object other) {
		if( this==other ) {
			return true;
		}
		if (other instanceof Event<?>) {
			Event<?> otherToken = (Event<?>) other;
			return otherToken.type.equals(this.type)
					&& otherToken.target.equals(this.target);
		} else {
			return false;
		}
	}
	
	@Override
	public String toString() {
		return getStandardId();
	}

	public String getIdInfo() {
		return idInfo;
	}

	public String getShortId() {
		String shortId = null;
		if (targetShort!=null) {
			shortId = targetShort+"."+getType();
			if (idInfo!=null) {
				shortId += "."+idInfo;
			}
		}
		return shortId;
	}

	public String getStandardId() {
		String id = target + "." + getType();
		if ( idInfo!=null ) {
			id += "." + idInfo;
		}
		return id;
	}

	public String getTarget() {
		return target;
	}
	
	public String getTargetShort() {
		return targetShort;
	}

	public String getType() {
		return type;
	}

	@Override
	public int hashCode() {
		int multiplier = 17;
		int hash = 42;
		hash = multiplier * hash + type.hashCode();
		if( target!=null ) {
			hash = multiplier * hash + target.hashCode();
		}

		return hash;
	}

	public void setIdInfo(String info) {
		idInfo = info;
	}
	
	/**
	 * <p>
	 * Sets the target of the event. Once set, the target cannot be changed.
	 * </p> 
	 * @param target target of the event
	 * @return true, if target was changed, false otherwise
	 */
	public boolean setTarget(String target) {
		if( this.target!=null ) {
			return false;
		}
		this.target = target;
		return true;
	}
	
	/**
	 * <p>
	 * Sets the short description of the event target. Once set, the target cannot be changed.
	 * </p> 
	 * @param targetShort short target description
	 * @return true, if target was changed, false otherwise
	 */
	public boolean setTargetShort(String targetShort) {
		if( this.targetShort!=null ) {
			return false;
		}
		this.targetShort = targetShort;
		return true;
	}
}
