package de.ugoe.cs.util;

final public class StringTools {

	public final static String ENDLINE = System.getProperty("line.separator");
	
	/**
	 * <p>
	 * Replaces all occurences of {@literal &, <, >, ', and "} with their
	 * respective XML entites {@literal &amp;, &lt;, &gt;, &apos;, and &quot;}
	 * without destroying already existing entities.
	 * </p>
	 * 
	 * @param str
	 *            String where the XML entites are to be replaced
	 * @return new String, where the XML entites are used instead of the
	 *         literals
	 */
	public static String xmlEntityReplacement(String str) {
		String result = str;
		result = result.replaceAll("&(?!(?:lt|gt|apos|quot|amp);)", "&amp;");
		result = result.replaceAll("<", "&lt;");
		result = result.replaceAll(">", "&gt;");
		result = result.replaceAll("'", "&apos;");
		result = result.replaceAll("\"", "&quot;");
		return result;
	}
}
