/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.bcp;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.bcp.Binding;
import edu.umd.cs.findbugs.ba.bcp.BindingSet;
import edu.umd.cs.findbugs.ba.bcp.MatchResult;
import edu.umd.cs.findbugs.ba.bcp.Variable;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import javax.annotation.CheckForNull;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;

public abstract class PatternElement {
    private static final boolean DEBUG = SystemProperties.getBoolean("bcp.debug");
    private PatternElement next;
    private String label;
    private String dominatedBy;
    private int index;
    private boolean allowTrailingEdges = true;

    public PatternElement getNext() {
        return this.next;
    }

    public void setNext(PatternElement patternElement) {
        this.next = patternElement;
    }

    public PatternElement label(String label) {
        this.label = label;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public PatternElement dominatedBy(String dominatedBy) {
        this.dominatedBy = dominatedBy;
        return this;
    }

    public String getDominatedBy() {
        return this.dominatedBy;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public PatternElement setAllowTrailingEdges(boolean allowTrailingEdges) {
        this.allowTrailingEdges = allowTrailingEdges;
        return this;
    }

    public boolean allowTrailingEdges() {
        return this.allowTrailingEdges;
    }

    public static Variable lookup(String varName, BindingSet bindingSet) {
        if (bindingSet == null) {
            return null;
        }
        Binding binding = bindingSet.lookup(varName);
        return binding != null ? binding.getVariable() : null;
    }

    @CheckForNull
    public abstract MatchResult match(InstructionHandle var1, ConstantPoolGen var2, ValueNumberFrame var3, ValueNumberFrame var4, BindingSet var5) throws DataflowAnalysisException;

    public abstract boolean acceptBranch(Edge var1, InstructionHandle var2);

    public abstract int minOccur();

    public abstract int maxOccur();

    protected static BindingSet addOrCheckDefinition(String varName, Variable variable, BindingSet bindingSet) {
        Variable existingVariable = PatternElement.lookup(varName, bindingSet);
        if (existingVariable == null) {
            bindingSet = new BindingSet(new Binding(varName, variable), bindingSet);
        } else if (!existingVariable.sameAs(variable)) {
            if (DEBUG) {
                System.out.println("\tConflicting variable " + varName + ": " + variable + " != " + existingVariable);
            }
            return null;
        }
        return bindingSet;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String className = this.getClass().getName();
        buf.append(className.substring(className.lastIndexOf(46) + 1));
        buf.append('(');
        buf.append(this.index);
        buf.append(')');
        return buf.toString();
    }
}

