package de.ugoe.cs.eventbench.jfc.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to pre-process files written by EventBench's JFCMonitor. The only task
 * of the pre-processing is checking if the session was closed properly, i.e.,
 * if the XML file ends with a {@code </sessions>} tag. If this is not the case,
 * the tag will be appended to the file.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDpreprocessJFC implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String source;
		String target;
		try {
			source = (String) parameters.get(0);
			target = (String) parameters.get(1);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		File file = new File(source);
		FileReader fileReader;
		try {
			fileReader = new FileReader(file);
		} catch (FileNotFoundException e) {
			Console.printerrln(e.getMessage());
			return;
		}
		char[] buffer = new char[(int) file.length()];
		try {
			fileReader.read(buffer);
			fileReader.close();
		} catch (IOException e) {
			Console.printerrln(e.getMessage());
			return;
		}

		String content = new String(buffer).trim();

		FileWriter writer;
		try {
			writer = new FileWriter(target);
		} catch (IOException e) {
			Console.printerrln(e.getMessage());
			return;
		}
		try {
			writer.write(content);
			if (!content.endsWith("</sessions>")) {
				writer.write("</sessions>");
			}
		} catch (IOException e) {
			Console.printerrln(e.getMessage());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: preprocessJFC <sourceFile> <targetFile>");
	}

}
