package de.ugoe.cs.eventbench.swt;

import java.util.SortedSet;

import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import de.ugoe.cs.eventbench.data.Event;

public class EditSequenceDialog extends Dialog {

	protected Shell shell;
	private Table table;
	private TableColumn tblclmnEventType;
	private TableColumn tblclmnEventTarget;
	
	private java.util.List<Event<?>> sequence;
	private SortedSet<String> targets;

	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public EditSequenceDialog(Shell parent, int style, SortedSet<String> targets) {
		super(parent, style);
		setText("SWT Dialog");
		this.targets = targets;
	}

	/**
	 * Open the dialog.
	 */
	public void open(java.util.List<Event<?>> sequence) {
		this.sequence = sequence;
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), SWT.SHELL_TRIM | SWT.BORDER | SWT.APPLICATION_MODAL);
		shell.setSize(450, 300);
		shell.setText(getText());
		shell.setLayout(new GridLayout(3, false));
		
		table = new Table(shell, SWT.BORDER | SWT.FULL_SELECTION);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		tblclmnEventType = new TableColumn(table, SWT.NONE);
		tblclmnEventType.setWidth(100);
		tblclmnEventType.setText("Event Type");
		
		tblclmnEventTarget = new TableColumn(table, SWT.NONE);
		tblclmnEventTarget.setWidth(100);
		tblclmnEventTarget.setText("Event Target");
		
		updateTableContents();
		
		Button btnInsertBefore = new Button(shell, SWT.NONE);
		btnInsertBefore.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				int index = table.getSelectionIndex();
				if( index==-1 ) {
					MessageBox messageBox = new MessageBox(shell, SWT.ERROR);
					messageBox.setMessage("No event selected!");
					messageBox.setText("Error");
					messageBox.open();
				} else {
					openInsertDialog(index);
				}
			}
		});
		btnInsertBefore.setText("Insert Before");
		
		Button btnInsertAfter = new Button(shell, SWT.NONE);
		btnInsertAfter.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				int index = table.getSelectionIndex();
				if( index==-1 ) {
					MessageBox messageBox = new MessageBox(shell, SWT.ERROR);
					messageBox.setMessage("No event selected!");
					messageBox.setText("Error");
					messageBox.open();
				} else {
					openInsertDialog(index+1);
				}
			}
		});
		btnInsertAfter.setText("Insert After");
		
		Button btnClose = new Button(shell, SWT.NONE);
		btnClose.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.dispose();
			}
		});
		btnClose.setText("Close");

	}
	
	private void updateTableContents() {
		table.removeAll();
		for( Event<?> event : sequence ) {
			TableItem tableItem = new TableItem(table, SWT.NONE);
			tableItem.setText(new String[]{event.getType(),event.getTarget()});
		}
	}
	
	private void openInsertDialog(int position) {
		InsertAssertionDialog insertDialog = new InsertAssertionDialog(shell, SWT.NONE, targets);
		Event<?> event = insertDialog.open();
		if( event!=null ) {
			sequence.add(position, event);
			updateTableContents();
		}
	}

}
