package de.ugoe.cs.util;

/**
 * <p>
 * Helper class that provides methods to simplify working with arrays.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
final public class ArrayTools {

	/**
	 * <p>
	 * Finds the first occurrence of an object inside an array.
	 * </p>
	 * <p>
	 * In case {@code other==null}, the first occurrence of a {@code null} value
	 * in the array is returned.
	 * </p>
	 * 
	 * @param array
	 *            the array
	 * @param other
	 *            the object
	 * @return index of the object if found, -1 otherwise
	 */
	public static int findIndex(Object[] array, Object other) {
		int retVal = -1;
		for (int i = 0; i < array.length && retVal == -1; i++) {
			if (other != null) {
				if (array[i] != null && array[i].equals(other)) {
					retVal = i;
				}
			} else {
				if (array[i] == null) {
					retVal = i;
				}
			}
		}
		return retVal;
	}

	/**
	 * <p>
	 * Finds the highest element in an array. If multiple elements have the
	 * maximum value, the index of the first one is returned; null-values are
	 * ignored. In case the parameter array is null, has length 0 or contains
	 * only null-values, -1 is returned.
	 * </p>
	 * 
	 * @param <T>
	 * @param array
	 *            the array
	 * @return index of the element with the highest value, -1 in case of an
	 *         invalid parameter
	 */
	@SuppressWarnings("unchecked")
	public static <T> int findMax(Comparable<T>[] array) {
		int maxIndex = -1;
		T maxElement = null;
		if (array != null) {
			for (int i = 0; i < array.length; i++) {
				if (array[i] != null) {
					if (maxElement == null
							|| array[i].compareTo(maxElement) > 0) {
						maxElement = (T) array[i];
						maxIndex = i;
					}
				}
			}
		}
		return maxIndex;
	}
	
	/**
	 * <p>
	 * Finds the lowest element in an array. If multiple elements have the
	 * minimal value, the index of the first one is returned; null-values are
	 * ignored. In case the parameter array is null, has length 0 or contains
	 * only null-values, -1 is returned.
	 * </p>
	 * 
	 * @param <T>
	 * @param array
	 *            the array
	 * @return index of the element with the lowest value, -1 in case of an
	 *         invalid parameter
	 */
	@SuppressWarnings("unchecked")
	public static <T> int findMin(Comparable<T>[] array) {
		int maxIndex = -1;
		T maxElement = null;
		if (array != null) {
			for (int i = 0; i < array.length; i++) {
				if (array[i] != null) {
					if (maxElement == null
							|| array[i].compareTo(maxElement) < 0) {
						maxElement = (T) array[i];
						maxIndex = i;
					}
				}
			}
		}
		return maxIndex;
	}
}
