package de.ugoe.cs.eventbench.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import de.ugoe.cs.eventbench.data.Event;

public class MockTrieBasedModel extends TrieBasedModel {
	private static final long serialVersionUID = 1L;

	public MockTrieBasedModel(int markovOrder, Random r) {
		super(markovOrder, r);
	}

	@Override
	public double getProbability(List<? extends Event<?>> context,
			Event<?> symbol) {
		List<Event<?>> list = new ArrayList<Event<?>>();
		list.add(context.get(context.size()-1));
		if( trie.find(list).getFollowingSymbols().contains(symbol) ) {
			return 1;
		} else {
			return 0;
		}
	}
}