/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.HTMLBugReporter;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.util.Bag;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class PrintingBugReporter
extends TextUIBugReporter {
    private final HashSet<BugInstance> seenAlready = new HashSet();

    public void observeClass(ClassDescriptor classDescriptor) {
    }

    protected void doReportBug(BugInstance bugInstance) {
        if (this.seenAlready.add(bugInstance)) {
            this.printBug(bugInstance);
            this.notifyObservers(bugInstance);
        }
    }

    public void finish() {
        this.outputStream.close();
    }

    public static void main(String[] args) throws Exception {
        FindBugs.setNoAnalysis();
        PrintingBugReporter reporter = new PrintingBugReporter();
        PrintingCommandLine commandLine = reporter.new PrintingCommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + PrintingCommandLine.class.getName() + " [options] [<xml results> [<test results]] ");
        if (commandLine.stylesheet != null) {
            PrintingBugReporter.xslt(commandLine.stylesheet, reporter.isApplySuppressions(), args, argCount);
            return;
        }
        SortedBugCollection bugCollection = new SortedBugCollection(commandLine.getProject());
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++]);
        } else {
            bugCollection.readXML(System.in);
        }
        if (argCount < args.length) {
            reporter.setOutputStream(UTF8.printStream(new FileOutputStream(args[argCount++]), true));
        }
        RuntimeException storedException = null;
        if (commandLine.annotationUploadFormat) {
            bugCollection.computeBugHashes();
            for (BugInstance warning : bugCollection) {
                try {
                    String string = "fb-" + warning.getInstanceHash() + "-" + warning.getInstanceOccurrenceNum() + "-" + warning.getInstanceOccurrenceMax();
                    System.out.print("#" + string);
                    String key = warning.getUserDesignationKey();
                    if (key.equals(BugDesignation.UNCLASSIFIED) || key.equals("NEEDS_FURTHER_STUDY")) {
                        System.out.print("#-1#" + key);
                    } else if (key.equals("MUST_FIX") || key.equals("SHOULD_FIX") || key.equals("I_WILL_FIX")) {
                        System.out.print("#7#" + key);
                    } else {
                        System.out.print("#0#" + key);
                    }
                    SourceLineAnnotation sourceLine = warning.getPrimarySourceLineAnnotation();
                    if (sourceLine != null) {
                        System.out.println("#" + sourceLine.getSourceFile() + "#" + sourceLine.getStartLine());
                    } else {
                        System.out.println("##");
                    }
                    System.out.println(warning.getAnnotationText());
                }
                catch (RuntimeException runtimeException) {
                    if (storedException != null) continue;
                    storedException = runtimeException;
                }
            }
        } else {
            Bag lowRank = new Bag(new TreeMap());
            for (BugInstance bugInstance : bugCollection.getCollection()) {
                if (reporter.isApplySuppressions() && bugCollection.getProject().getSuppressionFilter().match(bugInstance)) continue;
                int rank = bugInstance.getBugRank();
                BugPattern pattern = bugInstance.getBugPattern();
                if (rank <= commandLine.maxRank) {
                    try {
                        reporter.printBug(bugInstance);
                    }
                    catch (RuntimeException e) {
                        if (storedException != null) continue;
                        storedException = e;
                    }
                    continue;
                }
                if (rank > commandLine.summarizeMaxRank) continue;
                lowRank.add(pattern.getCategory());
            }
            reporter.finish();
            for (Map.Entry entry : lowRank.entrySet()) {
                System.out.printf("%4d low ranked %s issues%n", entry.getValue(), I18N.instance().getBugCategoryDescription((String)entry.getKey()));
            }
        }
        if (storedException != null) {
            throw storedException;
        }
    }

    public static void xslt(String stylesheet, boolean applySuppression, String[] args, int argCount) throws Exception {
        Project proj = new Project();
        HTMLBugReporter reporter = new HTMLBugReporter(proj, stylesheet);
        BugCollection bugCollection = reporter.getBugCollection();
        bugCollection.setApplySuppressions(applySuppression);
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++]);
        } else {
            bugCollection.readXML(System.in);
        }
        if (argCount < args.length) {
            reporter.setOutputStream(UTF8.printStream(new FileOutputStream(args[argCount++]), true));
        }
        reporter.finish();
        Exception e = reporter.getFatalException();
        if (e != null) {
            throw e;
        }
    }

    @CheckForNull
    public BugCollection getBugCollection() {
        return null;
    }

    class PrintingCommandLine
    extends CommandLine {
        private String stylesheet = null;
        private boolean annotationUploadFormat = false;
        private int maxRank = 20;
        private int summarizeMaxRank = 20;
        private Project project = new Project();

        public PrintingCommandLine() {
            this.addSwitch("-longBugCodes", "use long bug codes when generating text");
            this.addSwitch("-rank", "list rank when generating text");
            this.addOption("-maxRank", "max rank", "only list bugs of this rank or less");
            this.addOption("-summarizeMaxRank", "max rank", "summary bugs with of this rank or less");
            this.addSwitch("-designations", "report user designations for each bug");
            this.addSwitch("-history", "report first and last versions for each bug");
            this.addSwitch("-applySuppression", "exclude any bugs that match suppression filters");
            this.addSwitch("-annotationUpload", "generate annotations in upload format");
            this.addSwitchWithOptionalExtraPart("-html", "stylesheet", "Generate HTML output (default stylesheet is default.xsl)");
            this.addOption("-pluginList", "jar1[" + File.pathSeparator + "jar2...]", "specify list of plugin Jar files to load");
        }

        @Nonnull
        public Project getProject() {
            return this.project;
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (option.equals("-longBugCodes")) {
                PrintingBugReporter.this.setUseLongBugCodes(true);
            } else if (option.equals("-rank")) {
                PrintingBugReporter.this.setShowRank(true);
            } else if (option.equals("-designations")) {
                PrintingBugReporter.this.setReportUserDesignations(true);
            } else if (option.equals("-applySuppression")) {
                PrintingBugReporter.this.setApplySuppressions(true);
            } else if (option.equals("-history")) {
                PrintingBugReporter.this.setReportHistory(true);
            } else if (option.equals("-annotationUpload")) {
                this.annotationUploadFormat = true;
            } else if (option.equals("-html")) {
                this.stylesheet = !optionExtraPart.equals("") ? optionExtraPart : "default.xsl";
            } else {
                throw new IllegalArgumentException("Unknown option '" + option + "'");
            }
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-pluginList")) {
                String pluginListStr = argument;
                Map<String, Boolean> customPlugins = this.getProject().getConfiguration().getCustomPlugins();
                StringTokenizer tok = new StringTokenizer(pluginListStr, File.pathSeparator);
                while (tok.hasMoreTokens()) {
                    File file = new File(tok.nextToken());
                    Boolean enabled = file.isFile();
                    customPlugins.put(file.getAbsolutePath(), enabled);
                    if (!enabled.booleanValue()) continue;
                    try {
                        Plugin.loadCustomPlugin(file, this.getProject());
                    }
                    catch (PluginException e) {
                        throw new IllegalStateException("Failed to load plugin specified by the '-pluginList', file: " + file, e);
                    }
                }
            } else if (option.equals("-maxRank")) {
                this.maxRank = Integer.parseInt(argument);
            } else if (option.equals("-summarizeMaxRank")) {
                this.summarizeMaxRank = Integer.parseInt(argument);
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

