package de.ugoe.cs.util;

/**
 * <p>
 * Helper class that provides methods to simplify working with {@link String}s.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
final public class StringTools {

	/**
	 * <p>
	 * Private constructor to prevent initializing of the class.
	 * </p>
	 */
	private StringTools() {

	}

	/**
	 * <p>
	 * Simplifies use of operation system specific line separators.
	 * </p>
	 */
	public final static String ENDLINE = System.getProperty("line.separator");

	/**
	 * <p>
	 * Replaces all occurrences of {@literal &, <, >, ', and "} with their
	 * respective XML entities {@literal &amp;, &lt;, &gt;, &apos;, and &quot;}
	 * without destroying already existing entities.
	 * </p>
	 * 
	 * @param str
	 *            String where the XML entities are to be replaced
	 * @return new String, where the XML entities are used instead of the
	 *         literals
	 */
	public static String xmlEntityReplacement(String str) {
		String result = str;
		if (result != null && !"".equals(result)) {
			result = result
					.replaceAll("&(?!(?:lt|gt|apos|quot|amp);)", "&amp;");
			result = result.replaceAll("<", "&lt;");
			result = result.replaceAll(">", "&gt;");
			result = result.replaceAll("'", "&apos;");
			result = result.replaceAll("\"", "&quot;");
		}
		return result;
	}
}
