/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;

public class TestCaseDetector {
    private static final ClassDescriptor JUNIT4TEST = DescriptorFactory.createClassDescriptor("org/junit/Test");
    private static final ClassDescriptor JUNIT3TESTCASE = DescriptorFactory.createClassDescriptor("junit/framework/TestCase");

    public static boolean likelyTestCase(XMethod m) {
        if (m.getAnnotation(JUNIT4TEST) != null) {
            return true;
        }
        ClassDescriptor c = m.getClassDescriptor();
        if (m.getName().startsWith("test") || m.getName().startsWith("assert")) {
            Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
            try {
                if (subtypes2.isSubtype(c, JUNIT3TESTCASE)) {
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
            }
        }
        return false;
    }
}

